/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.hook;

import com.blade.mvc.handler.MethodArgument;
import com.blade.mvc.http.Request;
import com.blade.mvc.http.Response;
import com.blade.mvc.route.Route;
import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.util.Arrays;

public class Signature {
    private static final String LAMBDA = "$$Lambda$";
    private Route route;
    private Method action;
    private Request request;
    private Response response;
    private Object[] parameters;

    public Request request() {
        return this.request;
    }

    public Response response() {
        return this.response;
    }

    public boolean next() {
        return true;
    }

    public void setRoute(Route route) throws Exception {
        this.route = route;
        this.action = route.getAction();
        if (null != this.action && !this.action.toString().contains(LAMBDA)) {
            this.parameters = MethodArgument.getArgs(this);
        }
    }

    public static SignatureBuilder builder() {
        return new SignatureBuilder();
    }

    public Route getRoute() {
        return this.route;
    }

    public Method getAction() {
        return this.action;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setAction(Method action) {
        this.action = action;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Signature)) {
            return false;
        }
        Signature other = (Signature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Route this$route = this.getRoute();
        Route other$route = other.getRoute();
        if (this$route == null ? other$route != null : !((Object)this$route).equals(other$route)) {
            return false;
        }
        Method this$action = this.getAction();
        Method other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)this$action).equals(other$action)) {
            return false;
        }
        Request this$request = this.getRequest();
        Request other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Response this$response = this.getResponse();
        Response other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        return Arrays.deepEquals(this.getParameters(), other.getParameters());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Signature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Route $route = this.getRoute();
        result = result * 59 + ($route == null ? 43 : ((Object)$route).hashCode());
        Method $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)$action).hashCode());
        Request $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Response $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getParameters());
        return result;
    }

    public Signature() {
    }

    @ConstructorProperties(value={"route", "action", "request", "response", "parameters"})
    public Signature(Route route, Method action, Request request, Response response, Object[] parameters) {
        this.route = route;
        this.action = action;
        this.request = request;
        this.response = response;
        this.parameters = parameters;
    }

    public String toString() {
        return "Signature(route=" + this.getRoute() + ", action=" + this.getAction() + ", request=" + this.getRequest() + ", response=" + this.getResponse() + ", parameters=" + Arrays.deepToString(this.getParameters()) + ")";
    }

    public static class SignatureBuilder {
        private Route route;
        private Method action;
        private Request request;
        private Response response;
        private Object[] parameters;

        SignatureBuilder() {
        }

        public SignatureBuilder route(Route route) {
            this.route = route;
            return this;
        }

        public SignatureBuilder action(Method action) {
            this.action = action;
            return this;
        }

        public SignatureBuilder request(Request request) {
            this.request = request;
            return this;
        }

        public SignatureBuilder response(Response response) {
            this.response = response;
            return this;
        }

        public SignatureBuilder parameters(Object[] parameters) {
            this.parameters = parameters;
            return this;
        }

        public Signature build() {
            return new Signature(this.route, this.action, this.request, this.response, this.parameters);
        }

        public String toString() {
            return "Signature.SignatureBuilder(route=" + this.route + ", action=" + this.action + ", request=" + this.request + ", response=" + this.response + ", parameters=" + Arrays.deepToString(this.parameters) + ")";
        }
    }
}

