/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.http;

import com.blade.kit.StringKit;
import com.blade.kit.WebKit;
import com.blade.mvc.WebContext;
import com.blade.mvc.http.Cookie;
import com.blade.mvc.http.HttpMethod;
import com.blade.mvc.http.Session;
import com.blade.mvc.multipart.FileItem;
import com.blade.mvc.route.Route;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public interface Request {
    public Request initPathParams(Route var1);

    public String host();

    public String uri();

    public String url();

    default public String userAgent() {
        return this.header("User-Agent");
    }

    public String protocol();

    default public String contextPath() {
        return WebContext.contextPath();
    }

    public Map<String, String> pathParams();

    default public String pathString(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.pathParams().get(name);
    }

    default public Integer pathInt(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String val = this.pathString(name);
        return StringKit.isNotBlank(val) ? Integer.valueOf(Integer.parseInt(val)) : null;
    }

    default public Long pathLong(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String val = this.pathString(name);
        return StringKit.isNotBlank(val) ? Long.valueOf(Long.parseLong(val)) : null;
    }

    public String queryString();

    public Map<String, List<String>> parameters();

    default public Optional<String> query(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        List<String> values = this.parameters().get(name);
        if (null != values && values.size() > 0) {
            return Optional.of(values.get(0));
        }
        return Optional.empty();
    }

    default public String query(@NonNull String name, @NonNull String defaultValue) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        Optional<String> value = this.query(name);
        if (value.isPresent()) {
            return value.get();
        }
        return defaultValue;
    }

    default public Optional<Integer> queryInt(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Optional<String> value = this.query(name);
        if (value.isPresent()) {
            return Optional.of(Integer.parseInt(value.get()));
        }
        return Optional.empty();
    }

    default public int queryInt(@NonNull String name, int defaultValue) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Optional<String> value = this.query(name);
        if (value.isPresent()) {
            return Integer.parseInt(value.get());
        }
        return defaultValue;
    }

    default public Optional<Long> queryLong(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Optional<String> value = this.query(name);
        if (value.isPresent()) {
            return Optional.of(Long.parseLong(value.get()));
        }
        return Optional.empty();
    }

    default public long queryLong(@NonNull String name, long defaultValue) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Optional<String> value = this.query(name);
        if (value.isPresent()) {
            return Long.parseLong(value.get());
        }
        return defaultValue;
    }

    default public Optional<Double> queryDouble(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Optional<String> value = this.query(name);
        if (value.isPresent()) {
            return Optional.of(Double.parseDouble(value.get()));
        }
        return Optional.empty();
    }

    default public double queryDouble(@NonNull String name, double defaultValue) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        Optional<String> value = this.query(name);
        if (value.isPresent()) {
            return Double.parseDouble(value.get());
        }
        return defaultValue;
    }

    public String method();

    public HttpMethod httpMethod();

    default public String address() {
        return WebKit.ipAddr(this);
    }

    public Session session();

    default public String contentType() {
        String contentType = this.header("Content-Type");
        return null != contentType ? contentType : "Unknown";
    }

    public boolean isSecure();

    default public boolean isAjax() {
        return "XMLHttpRequest".equals(this.header("x-requested-with"));
    }

    default public boolean isIE() {
        String ua = this.userAgent();
        return ua.contains("MSIE") || ua.contains("TRIDENT");
    }

    public Map<String, String> cookies();

    default public Optional<String> cookie(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        String value = this.cookies().getOrDefault(name, "");
        if (value.length() > 0) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public Optional<Cookie> cookieRaw(String var1);

    default public String cookie(@NonNull String name, @NonNull String defaultValue) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        return this.cookie(name).isPresent() ? this.cookie(name).get() : defaultValue;
    }

    public Request cookie(Cookie var1);

    public Map<String, String> headers();

    default public String header(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.headers().getOrDefault(name, "");
    }

    default public String header(@NonNull String name, @NonNull String defaultValue) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue");
        }
        String value = this.header(name);
        return value.length() > 0 ? value : defaultValue;
    }

    public boolean keepAlive();

    public Map<String, Object> attributes();

    default public Request attribute(@NonNull String name, Object value) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (null != value) {
            this.attributes().put(name, value);
        }
        return this;
    }

    default public <T> T attribute(String name) {
        if (null == name) {
            return null;
        }
        Object object = this.attributes().get(name);
        return (T)(null != object ? object : null);
    }

    public Map<String, FileItem> fileItems();

    default public Optional<FileItem> fileItem(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return Optional.ofNullable(this.fileItems().get(name));
    }

    public ByteBuf body();

    public String bodyToString();
}

