/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.ui;

import java.util.List;

public class HtmlCreator {
    private static final String HTML_FOOTER = "<br/><p><center>Copyright \u00a9 <a href='https://github.com/biezhi/blade' target='_blank'>Blade-2.0.3</a></center></p><br/>";
    private StringBuilder html = new StringBuilder();

    public HtmlCreator() {
        this.html.append("<!DOCTYPE html>");
        this.html.append("<head>");
        this.html.append("<meta charset=\"utf-8\">");
        this.html.append("<style type='text/css'>.version{padding:10px;text-decoration-line: none;}.message-header{background-color: #900C3F;\ncolor: #fff;\n-webkit-box-align: center;\n-ms-flex-align: center;\nalign-items: center;\nborder-radius: 3px 3px 0 0;\ncolor: #fff;\ndisplay: -webkit-box;\ndisplay: -ms-flexbox;\ndisplay: flex;\n-webkit-box-pack: justify;\n-ms-flex-pack: justify;\njustify-content: space-between;\nline-height: 1.25;\npadding: 0.5em 0.75em;\nposition: relative;}.message-body{background-color: #fff5f7;font-size:1rem;border-color: #ff3860;\ncolor: #900C3F;\nborder-top-left-radius: 0;\nborder-top-right-radius: 0;\nborder-top: none;\nborder: 1px solid #dbdbdb;\nborder-radius: 3px;\npadding: 1em 1.25em;}</style>");
    }

    public HtmlCreator title(String title) {
        this.html.append("<title>").append(title).append("</title>");
        return this;
    }

    public HtmlCreator h1(String heading) {
        this.html.append("</head>");
        this.html.append("<body>");
        this.html.append("<h1>").append(heading).append("</h1>");
        return this;
    }

    public HtmlCreator h2(String heading) {
        this.html.append("<h2>").append(heading).append("</h2>");
        return this;
    }

    public HtmlCreator paragraph(String paragraph) {
        this.html.append("<p>").append(paragraph).append("</p>");
        return this;
    }

    public HtmlCreator startP() {
        this.html.append("<p>");
        return this;
    }

    public HtmlCreator startP(String className) {
        this.html.append("<p class='" + className + "'>");
        return this;
    }

    public HtmlCreator addBold(String text) {
        this.html.append("<b>").append(text).append("</b>");
        return this;
    }

    public HtmlCreator endP() {
        this.html.append("</p>");
        return this;
    }

    public HtmlCreator hr() {
        this.html.append("<hr/>");
        return this;
    }

    public HtmlCreator br() {
        this.html.append("<br/>");
        return this;
    }

    public HtmlCreator addTableWithHeaders(List<String> headers) {
        this.html.append("<table>");
        this.html.append("<tr>");
        headers.forEach(h -> this.html.append("<th>").append((String)h).append("</th>"));
        this.html.append("</tr>");
        return this;
    }

    public HtmlCreator addRowToTable(List<String> rowElements) {
        this.html.append("<tr>");
        rowElements.forEach(re -> this.html.append("<td>").append((String)re).append("</td>"));
        this.html.append("</tr>");
        return this;
    }

    public HtmlCreator endTable() {
        this.html.append("</table>");
        return this;
    }

    public HtmlCreator startStyle() {
        this.html.append("<style type='text/css'>");
        return this;
    }

    public HtmlCreator endStyle() {
        this.html.append("</style>");
        return this;
    }

    public HtmlCreator centerHeadings() {
        this.html.append("h1, h2 { text-align: center; }");
        return this;
    }

    public HtmlCreator add(String text) {
        this.html.append(text);
        return this;
    }

    public HtmlCreator styleTables() {
        this.html.append("table, th, td { margin: 0 auto; border: 1px solid black; border-collapse: collapse; text-align: center; }");
        return this;
    }

    public HtmlCreator center(String text) {
        this.html.append("<center>").append(text).append("</center>");
        return this;
    }

    public String toString() {
        return this.html.toString();
    }

    public String html() {
        this.html.append(HTML_FOOTER);
        this.html.append("</body>");
        return this.html.toString();
    }
}

