/*
 * Decompiled with CFR 0.152.
 */
package com.blade.security.web.filter;

import com.blade.security.web.filter.HTMLFilter;
import java.text.Normalizer;
import java.util.regex.Pattern;

public class InputFilter {
    private static final Pattern SCRIPT_PATTERN = Pattern.compile("<script>(.*?)</script>", 2);
    private static final Pattern SRC_PATTERN = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
    private static final Pattern SRC2_PATTERN = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
    private static final Pattern SCRIPT_END_PATTERN = Pattern.compile("</script>", 2);
    private static final Pattern SCRIPT_START_PATTERN = Pattern.compile("<script(.*?)>", 42);
    private static final Pattern EVAL_PATTERN = Pattern.compile("eval\\((.*?)\\)", 42);
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("expression\\((.*?)\\)", 42);
    private static final Pattern JAVASCRIPT_PATTERN = Pattern.compile("javascript:", 2);
    private static final Pattern VBSCRIPT_PATTERN = Pattern.compile("vbscript:", 2);
    private static final Pattern ONLOAD_PATTERN = Pattern.compile("onload(.*?)=", 42);
    private String value;

    public InputFilter(String value) {
        this.value = value;
    }

    public InputFilter htmlToText() {
        this.value = this.value.replaceAll("(?s)<[^>]*>(\\s*<[^>]*>)*", " ");
        return this;
    }

    public InputFilter cleanXss() {
        if (this.value != null) {
            String cleanValue = Normalizer.normalize(this.value, Normalizer.Form.NFD);
            cleanValue = cleanValue.replaceAll("\u0000", "");
            Pattern scriptPattern = SCRIPT_PATTERN;
            cleanValue = scriptPattern.matcher(cleanValue).replaceAll("");
            scriptPattern = SRC_PATTERN;
            cleanValue = scriptPattern.matcher(cleanValue).replaceAll("");
            scriptPattern = SRC2_PATTERN;
            cleanValue = scriptPattern.matcher(cleanValue).replaceAll("");
            scriptPattern = SCRIPT_END_PATTERN;
            cleanValue = scriptPattern.matcher(cleanValue).replaceAll("");
            scriptPattern = SCRIPT_START_PATTERN;
            cleanValue = scriptPattern.matcher(cleanValue).replaceAll("");
            scriptPattern = EVAL_PATTERN;
            cleanValue = scriptPattern.matcher(cleanValue).replaceAll("");
            scriptPattern = EXPRESSION_PATTERN;
            cleanValue = scriptPattern.matcher(cleanValue).replaceAll("");
            scriptPattern = JAVASCRIPT_PATTERN;
            cleanValue = scriptPattern.matcher(cleanValue).replaceAll("");
            scriptPattern = VBSCRIPT_PATTERN;
            cleanValue = scriptPattern.matcher(cleanValue).replaceAll("");
            scriptPattern = ONLOAD_PATTERN;
            this.value = scriptPattern.matcher(cleanValue).replaceAll("");
        }
        return this;
    }

    public InputFilter htmlFilter() {
        this.value = new HTMLFilter().filter(this.value);
        return this;
    }

    public String toString() {
        return this.value;
    }
}

