/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.exception.NotFoundException;
import com.blade.mvc.WebContext;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.handler.RequestInvoker;
import com.blade.mvc.hook.Signature;
import com.blade.mvc.http.HttpRequest;
import com.blade.mvc.http.HttpResponse;
import com.blade.mvc.http.Response;
import com.blade.mvc.route.Route;
import com.blade.mvc.route.RouteMatcher;
import com.blade.server.netty.SessionHandler;
import com.blade.server.netty.StaticFileHandler;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpServerHandler.class);
    private final Blade blade;
    private final RouteMatcher routeMatcher;
    private final Set<String> statics;
    private final SessionHandler sessionHandler;
    private final StaticFileHandler staticFileHandler;
    private final RequestInvoker requestInvoker;
    private final ExceptionHandler exceptionHandler;

    HttpServerHandler(Blade blade) {
        this.blade = blade;
        this.statics = blade.getStatics();
        this.exceptionHandler = blade.exceptionHandler();
        this.routeMatcher = blade.routeMatcher();
        this.requestInvoker = new RequestInvoker(blade);
        this.staticFileHandler = new StaticFileHandler(blade);
        this.sessionHandler = blade.sessionManager() != null ? new SessionHandler(blade) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest) {
        if (HttpUtil.is100ContinueExpected((HttpMessage)fullHttpRequest)) {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        HttpRequest request = HttpRequest.build(ctx, fullHttpRequest, this.sessionHandler);
        HttpResponse response = HttpResponse.build(ctx, this.blade.templateEngine());
        Signature signature = Signature.builder().request(request).response(response).build();
        try {
            String uri = request.uri();
            WebContext.set(new WebContext(request, response));
            if (this.isStaticFile(uri)) {
                this.staticFileHandler.handle(ctx, request, response);
                return;
            }
            log.info("{}\t{}\t{}", new Object[]{request.protocol(), request.method(), uri});
            Route route = this.routeMatcher.lookupRoute(request.method(), uri);
            if (null == route) {
                log.warn("Not Found\t{}", (Object)uri);
                throw new NotFoundException();
            }
            request.initPathParams(route);
            signature.setRoute(route);
            if (!this.requestInvoker.invokeMiddleware(this.routeMatcher.getMiddleware(), signature)) {
                this.sendFinish(response);
                return;
            }
            if (!this.requestInvoker.invokeHook(this.routeMatcher.getBefore(uri), signature)) {
                this.sendFinish(response);
                return;
            }
            signature.setRoute(route);
            this.requestInvoker.routeHandle(signature);
            this.requestInvoker.invokeHook(this.routeMatcher.getAfter(uri), signature);
        }
        catch (Exception e) {
            if (null != this.exceptionHandler) {
                this.exceptionHandler.handle(e);
            } else {
                log.error("Blade Invoke Error", (Throwable)e);
            }
        }
        finally {
            this.sendFinish(response);
            WebContext.remove();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (null != this.exceptionHandler) {
            this.exceptionHandler.handle((Exception)cause);
        } else {
            log.error("Blade Invoke Error", cause);
        }
        ctx.close();
    }

    private boolean isStaticFile(String uri) {
        Optional<String> result = this.statics.stream().filter(s -> s.equals(uri) || uri.startsWith((String)s)).findFirst();
        return result.isPresent();
    }

    private void sendFinish(Response response) {
        if (!response.isCommit()) {
            response.body(Unpooled.EMPTY_BUFFER);
        }
    }
}

