/*
 * Decompiled with CFR 0.152.
 */
package com.blade.server.netty;

import com.blade.Blade;
import com.blade.server.netty.HttpServerHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.handler.stream.ChunkedWriteHandler;

public class HttpServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final Blade blade;
    private final boolean enableGzip;
    private final boolean enableCors;

    public HttpServerInitializer(Blade blade) {
        this.blade = blade;
        this.enableGzip = blade.environment().getBoolean("http.gzip.enable", false);
        this.enableCors = blade.environment().getBoolean("http.cors.enable", false);
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        if (this.enableGzip) {
            p.addLast(new ChannelHandler[]{new HttpContentCompressor()});
        }
        p.addLast(new ChannelHandler[]{new HttpServerCodec(72384, 289536, 579072, false)});
        p.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
        p.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
        if (this.enableCors) {
            CorsConfig corsConfig = CorsConfigBuilder.forAnyOrigin().allowNullOrigin().allowCredentials().build();
            p.addLast(new ChannelHandler[]{new CorsHandler(corsConfig)});
        }
        p.addLast(new ChannelHandler[]{new HttpServerHandler(this.blade)});
    }
}

