/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.common.util;

import java.util.Objects;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

public class ApplicationInformation {
    public static String modId(ConfigurableEnvironment environment, ServerProperties serverProperties) {
        String applicationName = environment.getProperty("spring.application.name");
        applicationName = StringUtils.hasText((String)applicationName) ? applicationName : "application";
        return applicationName + ":" + ApplicationInformation.serverPort(serverProperties);
    }

    public static String[] splitAddress(String hostAndPort) {
        if (hostAndPort.indexOf(58) == -1) {
            throw new IllegalStateException("non exists port");
        }
        String[] result = hostAndPort.split(":");
        if (StringUtils.isEmpty((Object)result[0])) {
            result[0] = "0.0.0.0";
            return result;
        }
        if (result[0].charAt(0) == '/') {
            result[0] = result[0].substring(1);
            return result;
        }
        return result;
    }

    public static int serverPort(ServerProperties serverProperties) {
        return Objects.isNull(serverProperties) ? 0 : (Objects.isNull(serverProperties.getPort()) ? 8080 : serverProperties.getPort());
    }
}

