/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.search.queries.AbstractFtsQuery;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class DocIdQuery
extends AbstractFtsQuery {
    private List<String> docIds = new LinkedList<String>();

    public DocIdQuery(String ... docIds) {
        Collections.addAll(this.docIds, docIds);
    }

    public DocIdQuery docIds(String ... docIds) {
        Collections.addAll(this.docIds, docIds);
        return this;
    }

    @Override
    public DocIdQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        if (this.docIds.isEmpty()) {
            throw new IllegalArgumentException("DocID query needs at least one document ID");
        }
        JsonArray ids = JsonArray.from(this.docIds);
        input.put("ids", ids);
    }
}

