/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UserType;
import com.datastax.driver.mapping.AccessorMapper;
import com.datastax.driver.mapping.AnnotationChecks;
import com.datastax.driver.mapping.ColumnMapper;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.MappedUDTCodec;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.MethodMapper;
import com.datastax.driver.mapping.TypeMappings;
import com.datastax.driver.mapping.annotations.Accessor;
import com.datastax.driver.mapping.annotations.ClusteringColumn;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.Computed;
import com.datastax.driver.mapping.annotations.Defaults;
import com.datastax.driver.mapping.annotations.Field;
import com.datastax.driver.mapping.annotations.Frozen;
import com.datastax.driver.mapping.annotations.FrozenKey;
import com.datastax.driver.mapping.annotations.FrozenValue;
import com.datastax.driver.mapping.annotations.Param;
import com.datastax.driver.mapping.annotations.PartitionKey;
import com.datastax.driver.mapping.annotations.Query;
import com.datastax.driver.mapping.annotations.QueryParameters;
import com.datastax.driver.mapping.annotations.Table;
import com.datastax.driver.mapping.annotations.Transient;
import com.datastax.driver.mapping.annotations.UDT;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class AnnotationParser {
    private static final Comparator<java.lang.reflect.Field> fieldComparator = new Comparator<java.lang.reflect.Field>(){

        @Override
        public int compare(java.lang.reflect.Field f1, java.lang.reflect.Field f2) {
            return AnnotationParser.position(f1) - AnnotationParser.position(f2);
        }
    };

    private AnnotationParser() {
    }

    public static <T> EntityMapper<T> parseEntity(Class<T> entityClass, EntityMapper.Factory factory, MappingManager mappingManager) {
        ConsistencyLevel readConsistency;
        Table table = AnnotationChecks.getTypeAnnotation(Table.class, entityClass);
        String ksName = table.caseSensitiveKeyspace() ? table.keyspace() : table.keyspace().toLowerCase();
        String tableName = table.caseSensitiveTable() ? table.name() : table.name().toLowerCase();
        ConsistencyLevel writeConsistency = table.writeConsistency().isEmpty() ? null : ConsistencyLevel.valueOf((String)table.writeConsistency().toUpperCase());
        ConsistencyLevel consistencyLevel = readConsistency = table.readConsistency().isEmpty() ? null : ConsistencyLevel.valueOf((String)table.readConsistency().toUpperCase());
        if (Strings.isNullOrEmpty((String)table.keyspace()) && Strings.isNullOrEmpty((String)(ksName = mappingManager.getSession().getLoggedKeyspace()))) {
            throw new IllegalArgumentException(String.format("Error creating mapper for class %s, the @%s annotation declares no default keyspace, and the session is not currently logged to any keyspace", entityClass.getSimpleName(), Table.class.getSimpleName()));
        }
        EntityMapper mapper = factory.create(entityClass, ksName, tableName, writeConsistency, readConsistency);
        ArrayList<java.lang.reflect.Field> pks = new ArrayList<java.lang.reflect.Field>();
        ArrayList<java.lang.reflect.Field> ccs = new ArrayList<java.lang.reflect.Field>();
        ArrayList<java.lang.reflect.Field> rgs = new ArrayList<java.lang.reflect.Field>();
        block4: for (java.lang.reflect.Field field : entityClass.getDeclaredFields()) {
            if (field.isSynthetic() || (field.getModifiers() & 8) == 8) continue;
            if (mappingManager.isCassandraV1 && field.getAnnotation(Computed.class) != null) {
                throw new UnsupportedOperationException("Computed fields are not supported with native protocol v1");
            }
            AnnotationChecks.validateAnnotations(field, "entity", Column.class, ClusteringColumn.class, Frozen.class, FrozenKey.class, FrozenValue.class, PartitionKey.class, Transient.class, Computed.class);
            if (field.getAnnotation(Transient.class) != null) continue;
            switch (AnnotationParser.kind(field)) {
                case PARTITION_KEY: {
                    pks.add(field);
                    continue block4;
                }
                case CLUSTERING_COLUMN: {
                    ccs.add(field);
                    continue block4;
                }
                default: {
                    rgs.add(field);
                }
            }
        }
        AtomicInteger columnCounter = mappingManager.isCassandraV1 ? null : new AtomicInteger(0);
        Collections.sort(pks, fieldComparator);
        Collections.sort(ccs, fieldComparator);
        AnnotationParser.validateOrder(pks, "@PartitionKey");
        AnnotationParser.validateOrder(ccs, "@ClusteringColumn");
        mapper.addColumns(AnnotationParser.createColumnMappers(pks, factory, mapper.entityClass, mappingManager, columnCounter), AnnotationParser.createColumnMappers(ccs, factory, mapper.entityClass, mappingManager, columnCounter), AnnotationParser.createColumnMappers(rgs, factory, mapper.entityClass, mappingManager, columnCounter));
        return mapper;
    }

    private static <T> List<ColumnMapper<T>> createColumnMappers(List<java.lang.reflect.Field> fields, EntityMapper.Factory factory, Class<T> klass, MappingManager mappingManager, AtomicInteger columnCounter) {
        ArrayList<ColumnMapper<T>> mappers = new ArrayList<ColumnMapper<T>>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            java.lang.reflect.Field field;
            int pos = AnnotationParser.position(field = fields.get(i));
            mappers.add(factory.createColumnMapper(klass, field, pos < 0 ? i : pos, mappingManager, columnCounter));
        }
        return mappers;
    }

    public static <T> MappedUDTCodec<T> parseUDT(Class<T> udtClass, EntityMapper.Factory factory, MappingManager mappingManager) {
        String udtName;
        UDT udt = AnnotationChecks.getTypeAnnotation(UDT.class, udtClass);
        String ksName = udt.caseSensitiveKeyspace() ? udt.keyspace() : udt.keyspace().toLowerCase();
        String string = udtName = udt.caseSensitiveType() ? Metadata.quote((String)udt.name()) : udt.name().toLowerCase();
        if (Strings.isNullOrEmpty((String)udt.keyspace()) && Strings.isNullOrEmpty((String)(ksName = mappingManager.getSession().getLoggedKeyspace()))) {
            throw new IllegalArgumentException(String.format("Error creating UDT codec for class %s, the @%s annotation declares no default keyspace, and the session is not currently logged to any keyspace", udtClass.getSimpleName(), UDT.class.getSimpleName()));
        }
        UserType userType = mappingManager.getSession().getCluster().getMetadata().getKeyspace(ksName).getUserType(udtName);
        ArrayList<java.lang.reflect.Field> columns = new ArrayList<java.lang.reflect.Field>();
        for (java.lang.reflect.Field field : udtClass.getDeclaredFields()) {
            if (field.isSynthetic() || (field.getModifiers() & 8) == 8) continue;
            AnnotationChecks.validateAnnotations(field, "UDT", Field.class, Frozen.class, FrozenKey.class, FrozenValue.class, Transient.class);
            if (field.getAnnotation(Transient.class) != null) continue;
            switch (AnnotationParser.kind(field)) {
                case PARTITION_KEY: {
                    throw new IllegalArgumentException("Annotation @PartitionKey is not allowed in a class annotated by @UDT");
                }
                case CLUSTERING_COLUMN: {
                    throw new IllegalArgumentException("Annotation @ClusteringColumn is not allowed in a class annotated by @UDT");
                }
            }
            columns.add(field);
        }
        Map<String, ColumnMapper<T>> columnMappers = AnnotationParser.createFieldMappers(columns, factory, udtClass, mappingManager, null);
        return new MappedUDTCodec<T>(userType, udtClass, columnMappers, mappingManager);
    }

    private static <T> Map<String, ColumnMapper<T>> createFieldMappers(List<java.lang.reflect.Field> fields, EntityMapper.Factory factory, Class<T> klass, MappingManager mappingManager, AtomicInteger columnCounter) {
        HashMap mappers = Maps.newHashMapWithExpectedSize((int)fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            java.lang.reflect.Field field;
            int pos = AnnotationParser.position(field = fields.get(i));
            ColumnMapper<T> mapper = factory.createColumnMapper(klass, field, pos < 0 ? i : pos, mappingManager, columnCounter);
            mappers.put(mapper.getColumnName(), mapper);
        }
        return mappers;
    }

    private static void validateOrder(List<java.lang.reflect.Field> fields, String annotation) {
        for (int i = 0; i < fields.size(); ++i) {
            java.lang.reflect.Field field = fields.get(i);
            int pos = AnnotationParser.position(field);
            if (pos == i) continue;
            throw new IllegalArgumentException(String.format("Invalid ordering value %d for annotation %s of column %s, was expecting %d", pos, annotation, field.getName(), i));
        }
    }

    private static int position(java.lang.reflect.Field field) {
        switch (AnnotationParser.kind(field)) {
            case PARTITION_KEY: {
                return field.getAnnotation(PartitionKey.class).value();
            }
            case CLUSTERING_COLUMN: {
                return field.getAnnotation(ClusteringColumn.class).value();
            }
        }
        return -1;
    }

    public static ColumnMapper.Kind kind(java.lang.reflect.Field field) {
        PartitionKey pk = field.getAnnotation(PartitionKey.class);
        ClusteringColumn cc = field.getAnnotation(ClusteringColumn.class);
        Computed comp = field.getAnnotation(Computed.class);
        if (pk != null && cc != null) {
            throw new IllegalArgumentException("Field " + field.getName() + " cannot have both the @PartitionKey and @ClusteringColumn annotations");
        }
        if (pk != null) {
            return ColumnMapper.Kind.PARTITION_KEY;
        }
        if (cc != null) {
            return ColumnMapper.Kind.CLUSTERING_COLUMN;
        }
        if (comp != null) {
            return ColumnMapper.Kind.COMPUTED;
        }
        return ColumnMapper.Kind.REGULAR;
    }

    public static String columnName(java.lang.reflect.Field field) {
        Column column = field.getAnnotation(Column.class);
        Computed computedField = field.getAnnotation(Computed.class);
        if (column != null && !column.name().isEmpty()) {
            if (computedField != null) {
                throw new IllegalArgumentException("Cannot use @Column and @Computed on the same field");
            }
            return column.caseSensitive() ? column.name() : column.name().toLowerCase();
        }
        Field udtField = field.getAnnotation(Field.class);
        if (udtField != null && !udtField.name().isEmpty()) {
            return udtField.caseSensitive() ? udtField.name() : udtField.name().toLowerCase();
        }
        if (computedField != null) {
            return computedField.value();
        }
        return field.getName().toLowerCase();
    }

    public static String newAlias(java.lang.reflect.Field field, int columnNumber) {
        return "col" + columnNumber;
    }

    public static TypeCodec<Object> customCodec(java.lang.reflect.Field field) {
        Class<TypeCodec<?>> codecClass = AnnotationParser.getCodecClass(field);
        if (codecClass.equals(Defaults.NoCodec.class)) {
            return null;
        }
        try {
            TypeCodec<?> instance = codecClass.newInstance();
            return instance;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Cannot create an instance of custom codec %s for field %s", codecClass, field), e);
        }
    }

    private static Class<? extends TypeCodec<?>> getCodecClass(java.lang.reflect.Field field) {
        Column column = field.getAnnotation(Column.class);
        if (column != null) {
            return column.codec();
        }
        Field udtField = field.getAnnotation(Field.class);
        if (udtField != null) {
            return udtField.codec();
        }
        return Defaults.NoCodec.class;
    }

    public static <T> AccessorMapper<T> parseAccessor(Class<T> accClass, AccessorMapper.Factory factory, MappingManager mappingManager) {
        if (!accClass.isInterface()) {
            throw new IllegalArgumentException("@Accessor annotation is only allowed on interfaces");
        }
        AnnotationChecks.getTypeAnnotation(Accessor.class, accClass);
        ArrayList<MethodMapper> methods = new ArrayList<MethodMapper>();
        for (Method m : accClass.getDeclaredMethods()) {
            Query query = m.getAnnotation(Query.class);
            if (query == null) continue;
            String queryString = query.value();
            Annotation[][] paramAnnotations = m.getParameterAnnotations();
            Type[] paramTypes = m.getGenericParameterTypes();
            MethodMapper.ParamMapper[] paramMappers = new MethodMapper.ParamMapper[paramAnnotations.length];
            Boolean allParamsNamed = null;
            for (int i = 0; i < paramMappers.length; ++i) {
                boolean thisParamNamed;
                String paramName = null;
                Class<? extends TypeCodec<?>> codecClass = null;
                for (Annotation a : paramAnnotations[i]) {
                    if (!a.annotationType().equals(Param.class)) continue;
                    Param param = (Param)a;
                    paramName = param.value();
                    if (paramName.isEmpty()) {
                        paramName = null;
                    }
                    if (!Defaults.NoCodec.class.equals(codecClass = param.codec())) break;
                    codecClass = null;
                    break;
                }
                boolean bl = thisParamNamed = paramName != null;
                if (allParamsNamed == null) {
                    allParamsNamed = thisParamNamed;
                } else if (allParamsNamed != thisParamNamed) {
                    throw new IllegalArgumentException(String.format("For method '%s', either all or none of the parameters must be named", m.getName()));
                }
                paramMappers[i] = AnnotationParser.newParamMapper(accClass.getName(), m.getName(), i, paramName, codecClass, paramTypes[i], paramAnnotations[i], mappingManager);
            }
            ConsistencyLevel cl = null;
            int fetchSize = -1;
            boolean tracing = false;
            QueryParameters options = m.getAnnotation(QueryParameters.class);
            if (options != null) {
                cl = options.consistency().isEmpty() ? null : ConsistencyLevel.valueOf((String)options.consistency().toUpperCase());
                fetchSize = options.fetchSize();
                tracing = options.tracing();
            }
            methods.add(new MethodMapper(m, queryString, paramMappers, cl, fetchSize, tracing));
        }
        return factory.create(accClass, methods);
    }

    private static MethodMapper.ParamMapper newParamMapper(String className, String methodName, int idx, String paramName, Class<? extends TypeCodec<?>> codecClass, Type paramType, Annotation[] paramAnnotations, MappingManager mappingManager) {
        if (paramType instanceof Class) {
            Class paramClass = (Class)paramType;
            if (TypeMappings.isMappedUDT(paramClass)) {
                mappingManager.getUDTCodec(paramClass);
            }
            return new MethodMapper.ParamMapper(paramName, idx, TypeToken.of((Type)paramType), codecClass);
        }
        if (paramType instanceof ParameterizedType) {
            for (Class<?> udt : TypeMappings.findUDTs(paramType)) {
                mappingManager.getUDTCodec(udt);
            }
            return new MethodMapper.ParamMapper(paramName, idx, TypeToken.of((Type)paramType), codecClass);
        }
        throw new IllegalArgumentException(String.format("Cannot map class %s for parameter %s of %s.%s", paramType, paramName, className, methodName));
    }
}

