/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.CellRenderData;
import com.deepoove.poi.data.ParagraphRenderData;
import com.deepoove.poi.data.Paragraphs;
import com.deepoove.poi.data.PictureRenderData;
import com.deepoove.poi.data.RenderDataBuilder;
import com.deepoove.poi.data.TextRenderData;
import com.deepoove.poi.data.style.CellStyle;
import com.deepoove.poi.data.style.ParagraphStyle;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;

public class Cells {
    private Cells() {
    }

    public static CellBuilder of() {
        CellBuilder inst = new CellBuilder();
        return inst;
    }

    public static CellBuilder of(String text) {
        CellBuilder inst = Cells.of();
        inst.addParagraph(Paragraphs.of(text).create());
        return inst;
    }

    public static CellBuilder of(PictureRenderData picture) {
        CellBuilder inst = Cells.of();
        inst.addParagraph(picture);
        return inst;
    }

    public static CellBuilder of(TextRenderData text) {
        CellBuilder inst = Cells.of();
        inst.addParagraph(text);
        return inst;
    }

    public static CellRenderData create(String text) {
        return Cells.of(text).create();
    }

    public static class CellBuilder
    implements RenderDataBuilder<CellRenderData> {
        private CellRenderData data = new CellRenderData();

        private CellBuilder() {
        }

        public CellBuilder addParagraph(ParagraphRenderData para) {
            this.data.addParagraph(para);
            return this;
        }

        public CellBuilder addParagraph(TextRenderData text) {
            this.data.addParagraph(Paragraphs.of().addText(text).create());
            return this;
        }

        public CellBuilder addParagraph(String text) {
            this.data.addParagraph(Paragraphs.of().addText(text).create());
            return this;
        }

        public CellBuilder addParagraph(PictureRenderData picture) {
            this.data.addParagraph(Paragraphs.of().addPicture(picture).create());
            return this;
        }

        public CellBuilder bgColor(String color) {
            CellStyle defaultCellStyle = this.getCellStyle();
            defaultCellStyle.setBackgroundColor(color);
            return this;
        }

        public CellBuilder center() {
            this.verticalCenter();
            this.horizontalCenter();
            return this;
        }

        public CellBuilder verticalCenter() {
            CellStyle defaultCellStyle = this.getCellStyle();
            defaultCellStyle.setVertAlign(XWPFTableCell.XWPFVertAlign.CENTER);
            return this;
        }

        public CellBuilder horizontalCenter() {
            ParagraphStyle defaultParagraphStyle = this.getDefaultParagraphStyle();
            defaultParagraphStyle.setAlign(ParagraphAlignment.CENTER);
            return this;
        }

        public CellBuilder horizontalLeft() {
            ParagraphStyle defaultParagraphStyle = this.getDefaultParagraphStyle();
            defaultParagraphStyle.setAlign(ParagraphAlignment.LEFT);
            return this;
        }

        public CellBuilder horizontalRight() {
            ParagraphStyle defaultParagraphStyle = this.getDefaultParagraphStyle();
            defaultParagraphStyle.setAlign(ParagraphAlignment.RIGHT);
            return this;
        }

        private CellStyle getCellStyle() {
            CellStyle cellStyle = this.data.getCellStyle();
            if (null == cellStyle) {
                cellStyle = new CellStyle();
                this.data.setCellStyle(cellStyle);
            }
            return cellStyle;
        }

        private ParagraphStyle getDefaultParagraphStyle() {
            CellStyle cellStyle = this.getCellStyle();
            ParagraphStyle defaultParagraphStyle = cellStyle.getDefaultParagraphStyle();
            if (null == defaultParagraphStyle) {
                defaultParagraphStyle = ParagraphStyle.builder().build();
                cellStyle.setDefaultParagraphStyle(defaultParagraphStyle);
            }
            return defaultParagraphStyle;
        }

        @Override
        public CellRenderData create() {
            return this.data;
        }
    }
}

