/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.master;

import com.digitalpetri.modbus.codec.Modbus;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class ModbusTcpMasterConfig {
    private final String address;
    private final int port;
    private final Duration timeout;
    private final boolean autoConnect;
    private final Optional<String> instanceId;
    private final ExecutorService executor;
    private final EventLoopGroup eventLoop;
    private final HashedWheelTimer wheelTimer;
    private final Consumer<Bootstrap> bootstrapConsumer;

    public ModbusTcpMasterConfig(String address, int port, Duration timeout, @Deprecated boolean autoConnect, Optional<String> instanceId, ExecutorService executor, EventLoopGroup eventLoop, HashedWheelTimer wheelTimer, Consumer<Bootstrap> bootstrapConsumer) {
        this.address = address;
        this.port = port;
        this.timeout = timeout;
        this.autoConnect = autoConnect;
        this.instanceId = instanceId;
        this.executor = executor;
        this.eventLoop = eventLoop;
        this.wheelTimer = wheelTimer;
        this.bootstrapConsumer = bootstrapConsumer;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    @Deprecated
    public boolean isAutoConnect() {
        return this.autoConnect;
    }

    public Optional<String> getInstanceId() {
        return this.instanceId;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public EventLoopGroup getEventLoop() {
        return this.eventLoop;
    }

    public HashedWheelTimer getWheelTimer() {
        return this.wheelTimer;
    }

    public Consumer<Bootstrap> getBootstrapConsumer() {
        return this.bootstrapConsumer;
    }

    public static class Builder {
        private final String address;
        private int port = 502;
        private Duration timeout = Duration.ofSeconds(5L);
        private boolean autoConnect = true;
        private Optional<String> instanceId = Optional.empty();
        private ExecutorService executor;
        private EventLoopGroup eventLoop;
        private HashedWheelTimer wheelTimer;
        private Consumer<Bootstrap> bootstrapConsumer = b -> {};

        public Builder(String address) {
            this.address = address;
        }

        public Builder setPort(int port) {
            this.port = port;
            return this;
        }

        public Builder setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        @Deprecated
        public Builder setAutoConnect(boolean autoConnect) {
            this.autoConnect = autoConnect;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this.instanceId = Optional.of(instanceId);
            return this;
        }

        public Builder setExecutor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder setEventLoop(EventLoopGroup eventLoop) {
            this.eventLoop = eventLoop;
            return this;
        }

        public Builder setWheelTimer(HashedWheelTimer wheelTimer) {
            this.wheelTimer = wheelTimer;
            return this;
        }

        public Builder setBootstrapConsumer(Consumer<Bootstrap> consumer) {
            this.bootstrapConsumer = consumer;
            return this;
        }

        public ModbusTcpMasterConfig build() {
            return new ModbusTcpMasterConfig(this.address, this.port, this.timeout, this.autoConnect, this.instanceId, this.executor != null ? this.executor : Modbus.sharedExecutor(), this.eventLoop != null ? this.eventLoop : Modbus.sharedEventLoop(), this.wheelTimer != null ? this.wheelTimer : Modbus.sharedWheelTimer(), this.bootstrapConsumer);
        }
    }
}

