/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher;

import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SqlSnippet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanMeta<T> {
    private final Class<T> beanClass;
    private final String dataSource;
    private final SqlSnippet tableSnippet;
    private final SqlSnippet joinCondSnippet;
    private final SqlSnippet groupBySnippet;
    private final boolean distinct;
    private final Map<String, FieldMeta> fieldMetaMap = new HashMap<String, FieldMeta>();

    public BeanMeta(Class<T> beanClass, String dataSource, SqlSnippet tableSnippet, SqlSnippet joinCondSnippet, SqlSnippet groupBySnippet, boolean distinct) {
        this.beanClass = beanClass;
        this.dataSource = dataSource;
        this.tableSnippet = tableSnippet;
        this.joinCondSnippet = joinCondSnippet;
        this.groupBySnippet = groupBySnippet;
        this.distinct = distinct;
    }

    public void addFieldMeta(String field, FieldMeta meta) {
        if (this.fieldMetaMap.containsKey(field)) {
            throw new SearchException("\u4e0d\u53ef\u4ee5\u91cd\u590d\u6dfb\u52a0\u5b57\u6bb5\uff1a" + field);
        }
        this.fieldMetaMap.put(field, meta);
    }

    public Class<T> getBeanClass() {
        return this.beanClass;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public SqlSnippet getTableSnippet() {
        return this.tableSnippet;
    }

    public String getJoinCond() {
        return this.joinCondSnippet.getSnippet();
    }

    public List<SqlSnippet.Param> getJoinCondEmbedParams() {
        return this.joinCondSnippet.getParams();
    }

    public String getGroupBy() {
        return this.groupBySnippet.getSnippet();
    }

    public List<SqlSnippet.Param> getGroupByEmbedParams() {
        return this.groupBySnippet.getParams();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Set<String> getFieldSet() {
        return Collections.unmodifiableSet(this.fieldMetaMap.keySet());
    }

    public int getFieldCount() {
        return this.fieldMetaMap.size();
    }

    public FieldMeta requireFieldMeta(String field) {
        FieldMeta meta = this.getFieldMeta(field);
        if (meta == null) {
            throw new IllegalStateException("No such field named: " + field);
        }
        return meta;
    }

    public FieldMeta getFieldMeta(String field) {
        if (field != null) {
            return this.fieldMetaMap.get(field);
        }
        return null;
    }

    public String getFieldSql(String field) {
        FieldMeta meta = this.getFieldMeta(field);
        if (meta != null) {
            return meta.getFieldSql().getSnippet();
        }
        return null;
    }

    public Collection<FieldMeta> getFieldMetas() {
        return Collections.unmodifiableCollection(this.fieldMetaMap.values());
    }
}

