/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher;

import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchSql;
import java.io.Closeable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SqlResult<T>
implements Closeable {
    private final SearchSql<T> searchSql;
    private ResultSet listResult;
    private ResultSet clusterResult;
    private Statement listStatement;
    private Statement clusterStatement;

    public SqlResult(SearchSql<T> searchSql) {
        this.searchSql = searchSql;
    }

    @Override
    public void close() {
        try {
            if (this.listResult != null) {
                this.listResult.close();
            }
            if (this.clusterResult != null) {
                this.clusterResult.close();
            }
            if (this.listStatement != null) {
                this.listStatement.close();
            }
            if (this.clusterStatement != null) {
                this.clusterStatement.close();
            }
        }
        catch (SQLException e) {
            throw new SearchException("Can not close statement or resultSet!", e);
        }
    }

    public SearchSql<T> getSearchSql() {
        return this.searchSql;
    }

    public ResultSet getListResult() {
        return this.listResult;
    }

    public void setListResult(ResultSet listResult, Statement listStatement) {
        this.listResult = listResult;
        this.listStatement = listStatement;
    }

    public ResultSet getAlreadyClusterResult() throws SQLException {
        if (this.clusterResult != null && this.clusterResult.isBeforeFirst()) {
            this.clusterResult.next();
        }
        return this.clusterResult;
    }

    public void setClusterResult(ResultSet clusterResult, Statement clusterStatement) {
        this.clusterResult = clusterResult;
        this.clusterStatement = clusterStatement;
    }
}

