/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.dialect;

import com.ejlchina.searcher.dialect.Dialect;
import com.ejlchina.searcher.param.Paging;

public class MySqlDialect
implements Dialect {
    @Override
    public void toUpperCase(StringBuilder builder, String dbField) {
        builder.append("upper").append("(").append(dbField).append(")");
    }

    @Override
    public void truncateToDateStr(StringBuilder builder, String dbField) {
        builder.append("date_format(").append(dbField).append(", '%Y-%m-%d')");
    }

    @Override
    public void truncateToDateMinuteStr(StringBuilder builder, String dbField) {
        builder.append("date_format(").append(dbField).append(", '%Y-%m-%d %H:%i')");
    }

    @Override
    public void truncateToDateSecondStr(StringBuilder builder, String dbField) {
        builder.append("date_format(").append(dbField).append(", '%Y-%m-%d %H:%i:%s')");
    }

    @Override
    public Dialect.PaginateSql forPaginate(String fieldSelectSql, String fromWhereSql, Paging paging) {
        Dialect.PaginateSql paginateSql = new Dialect.PaginateSql();
        StringBuilder ret = new StringBuilder();
        ret.append(fieldSelectSql).append(fromWhereSql);
        if (paging != null) {
            ret.append(" limit ?, ?");
            paginateSql.addParam(paging.getOffset());
            paginateSql.addParam(paging.getSize());
        }
        paginateSql.setSql(ret.toString());
        return paginateSql;
    }
}

