/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.param.Operator;
import java.util.regex.Pattern;

public class DateValueCorrector {
    static final Pattern DATE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
    static final Pattern DATE_HOUR_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}");
    static final Pattern DATE_MINUTE_PATTERN = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2} [0-9]{2}:[0-9]{2}");

    public Object[] correct(Object[] dateValues, Operator operator) {
        switch (operator) {
            case LessThan: 
            case GreaterEqual: {
                for (int i = 0; i < dateValues.length; ++i) {
                    dateValues[i] = this.dateValue(dateValues[i], true);
                }
                break;
            }
            case LessEqual: 
            case GreaterThan: {
                for (int i = 0; i < dateValues.length; ++i) {
                    dateValues[i] = this.dateValue(dateValues[i], false);
                }
                break;
            }
            case Between: {
                if (dateValues.length > 0) {
                    dateValues[0] = this.dateValue(dateValues[0], true);
                }
                if (dateValues.length <= 1) break;
                dateValues[1] = this.dateValue(dateValues[1], false);
                break;
            }
        }
        return dateValues;
    }

    protected Object dateValue(Object value, boolean roundDown) {
        if (value instanceof String) {
            String strValue = (String)value;
            if (DATE_PATTERN.matcher(strValue).matches()) {
                if (roundDown) {
                    return strValue + " 00:00:00";
                }
                return strValue + " 23:59:59";
            }
            if (DATE_HOUR_PATTERN.matcher(strValue).matches()) {
                if (roundDown) {
                    return strValue + ":00:00";
                }
                return strValue + ":59:59";
            }
            if (DATE_MINUTE_PATTERN.matcher(strValue).matches()) {
                if (roundDown) {
                    return strValue + ":00";
                }
                return strValue + ":59";
            }
        }
        return value;
    }
}

