/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.BeanReflector;
import com.ejlchina.searcher.BeanSearcher;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchResult;
import com.ejlchina.searcher.SearchSql;
import com.ejlchina.searcher.SqlExecutor;
import com.ejlchina.searcher.SqlResult;
import com.ejlchina.searcher.bean.BeanAware;
import com.ejlchina.searcher.bean.ParamAware;
import com.ejlchina.searcher.implement.AbstractSearcher;
import com.ejlchina.searcher.implement.DefaultBeanReflector;
import com.ejlchina.searcher.param.FetchType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DefaultBeanSearcher
extends AbstractSearcher
implements BeanSearcher {
    private BeanReflector beanReflector = new DefaultBeanReflector();

    public DefaultBeanSearcher() {
    }

    public DefaultBeanSearcher(SqlExecutor sqlExecutor) {
        super(sqlExecutor);
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(0));
    }

    @Override
    public <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, String[] summaryFields) {
        return this.search(beanClass, paraMap, new FetchType(0, summaryFields));
    }

    @Override
    public <T> T searchFirst(Class<T> beanClass, Map<String, Object> paraMap) {
        FetchType fetchType = new FetchType(1);
        List<T> list = this.search(beanClass, paraMap, fetchType).getDataList();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T> List<T> searchList(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(2)).getDataList();
    }

    @Override
    public <T> List<T> searchAll(Class<T> beanClass, Map<String, Object> paraMap) {
        return this.search(beanClass, paraMap, new FetchType(3)).getDataList();
    }

    protected <T> SearchResult<T> search(Class<T> beanClass, Map<String, Object> paraMap, FetchType fetchType) {
        SqlResult<T> sqlResult = this.doSearch(beanClass, paraMap, fetchType);
        try {
            SearchResult result;
            ResultSet listResult = sqlResult.getListResult();
            ResultSet clusterResult = sqlResult.getAlreadyClusterResult();
            if (listResult != null) {
                SearchSql<T> searchSql = sqlResult.getSearchSql();
                BeanMeta<T> beanMeta = searchSql.getBeanMeta();
                List<String> fetchFields = searchSql.getFetchFields();
                result = new SearchResult<T>(this.toBeanList(listResult, beanMeta, fetchFields, paraMap));
            } else {
                result = new SearchResult();
            }
            if (clusterResult != null) {
                result.setTotalCount(this.getCountFromSqlResult(sqlResult));
                result.setSummaries(this.getSummaryFromSqlResult(sqlResult));
            }
            SearchResult searchResult = result;
            if (sqlResult != null) {
                sqlResult.close();
            }
            return searchResult;
        }
        catch (Throwable throwable) {
            try {
                if (sqlResult != null) {
                    try {
                        sqlResult.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new SearchException("A exception occurred when collecting sql result!", e);
            }
        }
    }

    protected <T> List<T> toBeanList(ResultSet listResult, BeanMeta<T> beanMeta, List<String> fetchFields, Map<String, Object> paraMap) throws SQLException {
        ArrayList<T> dataList = new ArrayList<T>();
        while (listResult.next()) {
            T bean = this.beanReflector.reflect(beanMeta, fetchFields, dbAlias -> {
                try {
                    return listResult.getObject((String)dbAlias);
                }
                catch (SQLException e) {
                    throw new SearchException("A exception occurred when collecting sql result!", e);
                }
            });
            if (bean instanceof BeanAware) {
                ((BeanAware)bean).afterAssembly();
            }
            if (bean instanceof ParamAware) {
                ((ParamAware)bean).afterAssembly(paraMap);
            }
            dataList.add(bean);
        }
        return dataList;
    }

    public BeanReflector getBeanReflector() {
        return this.beanReflector;
    }

    public void setBeanReflector(BeanReflector beanReflector) {
        this.beanReflector = Objects.requireNonNull(beanReflector);
    }
}

