/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.DbMapping;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.MetaResolver;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SnippetResolver;
import com.ejlchina.searcher.SqlSnippet;
import com.ejlchina.searcher.bean.DbField;
import com.ejlchina.searcher.bean.DbIgnore;
import com.ejlchina.searcher.bean.SearchBean;
import com.ejlchina.searcher.implement.DefaultSnippetResolver;
import com.ejlchina.searcher.param.Operator;
import com.ejlchina.searcher.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultMetaResolver
implements MetaResolver {
    private static final Operator[] EMPTY_OPERATORS = new Operator[0];
    private final Map<Class<?>, BeanMeta<?>> cache = new ConcurrentHashMap();
    private SnippetResolver snippetResolver = new DefaultSnippetResolver();
    private DbMapping dbMapping = new DbMapping(){

        @Override
        public String table(Class<?> beanClass) {
            return StringUtils.toUnderline(beanClass.getSimpleName());
        }

        @Override
        public String column(Field field) {
            return StringUtils.toUnderline(field.getName());
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> BeanMeta<T> resolve(Class<T> beanClass) {
        BeanMeta<Object> beanMeta = this.cache.get(beanClass);
        if (beanMeta != null) {
            return beanMeta;
        }
        Map<Class<?>, BeanMeta<?>> map = this.cache;
        synchronized (map) {
            beanMeta = this.resolveMetadata(beanClass);
            this.cache.put(beanClass, beanMeta);
            return beanMeta;
        }
    }

    protected <T> BeanMeta<T> resolveMetadata(Class<T> beanClass) {
        SearchBean bean = beanClass.getAnnotation(SearchBean.class);
        BeanMeta<T> beanMeta = new BeanMeta<T>(beanClass, bean != null ? bean.dataSource().trim() : null, this.snippetResolver.resolve(this.tables(beanClass, bean)), this.snippetResolver.resolve(this.joinCond(bean)), this.snippetResolver.resolve(this.groupBy(bean)), bean != null && bean.distinct());
        Field[] fields = beanClass.getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            String fieldSql = this.dbFieldSql(bean, field);
            if (fieldSql == null) continue;
            SqlSnippet fieldSnippet = this.snippetResolver.resolve(fieldSql);
            FieldMeta fieldMeta = this.resolveFieldMeta(beanMeta, field, fieldSnippet, index);
            beanMeta.addFieldMeta(field.getName(), fieldMeta);
        }
        if (beanMeta.getFieldCount() == 0) {
            throw new SearchException("[" + beanClass.getName() + "] is not a valid SearchBean, because there is no field mapping to database.");
        }
        return beanMeta;
    }

    protected FieldMeta resolveFieldMeta(BeanMeta<?> beanMeta, Field field, SqlSnippet snippet, int index) {
        Class<?> beanClass = beanMeta.getBeanClass();
        Method setter = this.getSetterMethod(beanClass, field);
        String dbAlias = "_" + index;
        DbField dbField = field.getAnnotation(DbField.class);
        boolean conditional = dbField == null || dbField.conditional();
        Operator[] onlyOn = dbField != null ? dbField.onlyOn() : EMPTY_OPERATORS;
        return new FieldMeta(beanMeta, field, setter, snippet, dbAlias, conditional, onlyOn);
    }

    protected Method getSetterMethod(Class<?> beanClass, Field field) {
        String fieldName = field.getName();
        try {
            return beanClass.getMethod("set" + StringUtils.firstCharToUpperCase(fieldName), field.getType());
        }
        catch (Exception e) {
            throw new SearchException("[" + beanClass.getName() + ": " + fieldName + "] is annotated by @DbField, but there is no correctly setter for it.", e);
        }
    }

    protected String tables(Class<?> beanClass, SearchBean bean) {
        if (bean == null || StringUtils.isBlank(bean.tables())) {
            String table = this.dbMapping.table(beanClass);
            if (StringUtils.isBlank(table)) {
                throw new SearchException("The class [" + beanClass.getName() + "] can not be searched, because there is no table mapping provided by @SearchBean and DbMapping");
            }
            return table.trim();
        }
        return bean.tables().trim();
    }

    protected String joinCond(SearchBean bean) {
        return bean != null ? bean.joinCond().trim() : "";
    }

    protected String groupBy(SearchBean bean) {
        return bean != null ? bean.groupBy().trim() : "";
    }

    protected String dbFieldSql(SearchBean bean, Field field) {
        boolean dbIgnore;
        DbField dbField = field.getAnnotation(DbField.class);
        boolean bl = dbIgnore = field.getAnnotation(DbIgnore.class) != null;
        if (dbField != null) {
            if (dbIgnore) {
                throw new SearchException("[" + field.getDeclaringClass().getName() + ": " + field.getName() + "] is annotated by @DbField and @DbIgnore, which are mutually exclusive.");
            }
            String fieldSql = dbField.value().trim();
            if (StringUtils.isNotBlank(fieldSql)) {
                if (fieldSql.toLowerCase().startsWith("select ")) {
                    return "(" + fieldSql + ")";
                }
                return fieldSql;
            }
        }
        if (dbIgnore) {
            return null;
        }
        if (bean == null || StringUtils.isBlank(bean.tables())) {
            return this.getColumn(field);
        }
        String tab = bean.autoMapTo();
        if (StringUtils.isBlank(tab)) {
            return null;
        }
        String column = this.getColumn(field);
        if (column == null) {
            return null;
        }
        return tab.trim() + "." + column;
    }

    private String getColumn(Field field) {
        String column = this.dbMapping.column(field);
        if (StringUtils.isBlank(column)) {
            return null;
        }
        return column.trim();
    }

    public SnippetResolver getSnippetResolver() {
        return this.snippetResolver;
    }

    public void setSnippetResolver(SnippetResolver snippetResolver) {
        this.snippetResolver = Objects.requireNonNull(snippetResolver);
    }

    public DbMapping getDbMapping() {
        return this.dbMapping;
    }

    public void setDbMapping(DbMapping dbMapping) {
        this.dbMapping = Objects.requireNonNull(dbMapping);
    }
}

