/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.PageExtractor;
import com.ejlchina.searcher.ParamFilter;
import com.ejlchina.searcher.ParamResolver;
import com.ejlchina.searcher.SearchParam;
import com.ejlchina.searcher.implement.BoolValueFilter;
import com.ejlchina.searcher.implement.PageOffsetExtractor;
import com.ejlchina.searcher.param.FetchType;
import com.ejlchina.searcher.param.FieldParam;
import com.ejlchina.searcher.param.Operator;
import com.ejlchina.searcher.param.OrderBy;
import com.ejlchina.searcher.param.Paging;
import com.ejlchina.searcher.util.MapBuilder;
import com.ejlchina.searcher.util.ObjectUtils;
import com.ejlchina.searcher.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DefaultParamResolver
implements ParamResolver {
    public static final Pattern INDEX_PATTERN = Pattern.compile("[0-9]+");
    private PageExtractor pageExtractor = new PageOffsetExtractor();
    private ParamFilter[] paramFilters = new ParamFilter[]{new BoolValueFilter()};
    private String sortName = "sort";
    private String orderName = "order";
    private String separator = "-";
    private String ignoreCaseSuffix = "ic";
    private String operatorSuffix = "op";
    private String onlySelectName = "onlySelect";
    private String selectExcludeName = "selectExclude";

    @Override
    public SearchParam resolve(BeanMeta<?> beanMeta, FetchType fetchType, Map<String, Object> paraMap) {
        for (ParamFilter filter : this.paramFilters) {
            if (paraMap == null) break;
            paraMap = filter.doFilter(beanMeta, paraMap);
        }
        if (paraMap == null) {
            paraMap = new HashMap<String, Object>();
        }
        return this.doResolve(beanMeta, fetchType, paraMap);
    }

    protected SearchParam doResolve(BeanMeta<?> beanMeta, FetchType fetchType, Map<String, Object> paraMap) {
        Object value;
        SearchParam searchParam = new SearchParam(paraMap, fetchType, this.resolveFetchFields(beanMeta, fetchType, paraMap), this.resolveFieldParams(beanMeta.getFieldMetas(), paraMap));
        if (fetchType.canPaging()) {
            Paging paging;
            value = paraMap.get(MapBuilder.PAGING);
            Paging paging2 = paging = value instanceof Paging ? (Paging)value : this.pageExtractor.extract(paraMap);
            if (fetchType.isFetchFirst()) {
                paging.setSize(1);
            }
            searchParam.setPaging(paging);
        }
        if (fetchType.shouldQueryList()) {
            value = paraMap.get(MapBuilder.ORDER_BY);
            if (value instanceof OrderBy) {
                searchParam.setOrderBy((OrderBy)value);
            } else {
                searchParam.setOrderBy(this.resolveOrderBy(beanMeta.getFieldSet(), paraMap));
            }
        }
        return searchParam;
    }

    protected List<String> resolveFetchFields(BeanMeta<?> beanMeta, FetchType fetchType, Map<String, Object> paraMap) {
        if (fetchType.shouldQueryList() || beanMeta.isDistinct() || StringUtils.isNotBlank(beanMeta.getGroupBy())) {
            Set<String> fieldList = beanMeta.getFieldSet();
            List onlySelect = ObjectUtils.toList(this.getOnlySelect(paraMap)).stream().filter(fieldList::contains).collect(Collectors.toList());
            List<String> selectExclude = ObjectUtils.toList(this.getSelectExclude(paraMap));
            return (onlySelect.isEmpty() ? fieldList : onlySelect).stream().filter(f -> !selectExclude.contains(f)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Object getSelectExclude(Map<String, Object> paraMap) {
        Object value = paraMap.get(MapBuilder.SELECT_EXCLUDE);
        if (value != null) {
            return value;
        }
        return paraMap.get(this.selectExcludeName);
    }

    private Object getOnlySelect(Map<String, Object> paraMap) {
        Object value = paraMap.get(MapBuilder.ONLY_SELECT);
        if (value != null) {
            return value;
        }
        return paraMap.get(this.onlySelectName);
    }

    protected List<FieldParam> resolveFieldParams(Collection<FieldMeta> fieldMetas, Map<String, Object> paraMap) {
        HashMap<String, Set<Integer>> fieldIndicesMap = new HashMap<String, Set<Integer>>();
        for (String key : paraMap.keySet()) {
            String suffix;
            int index = key.lastIndexOf(this.separator);
            if (index > 0 && key.length() > index + 1 && INDEX_PATTERN.matcher(suffix = key.substring(index + 1)).matches()) {
                String field = key.substring(0, index);
                this.mapFieldIndex(fieldIndicesMap, field, Integer.parseInt(suffix));
            }
            this.mapFieldIndex(fieldIndicesMap, key, 0);
        }
        ArrayList<FieldParam> fieldParams = new ArrayList<FieldParam>();
        for (FieldMeta meta : fieldMetas) {
            Set indices;
            FieldParam param;
            if (!meta.isConditional() || (param = this.toFieldParam(meta, indices = (Set)fieldIndicesMap.get(meta.getName()), paraMap)) == null) continue;
            fieldParams.add(param);
        }
        return fieldParams;
    }

    protected void mapFieldIndex(Map<String, Set<Integer>> fieldIndicesKeysMap, String field, int index) {
        fieldIndicesKeysMap.computeIfAbsent(field, k -> new HashSet(2)).add(index);
    }

    private FieldParam getFieldParam(Map<String, Object> paraMap, String field) {
        Object value = paraMap.get(MapBuilder.FIELD_PARAM + "." + field);
        if (value instanceof FieldParam) {
            return (FieldParam)value;
        }
        return null;
    }

    protected FieldParam toFieldParam(FieldMeta meta, Set<Integer> indices, Map<String, Object> paraMap) {
        ArrayList<FieldParam.Value> values;
        FieldParam param;
        String field = meta.getName();
        Operator op = this.toOperator(field, paraMap, param = this.getFieldParam(paraMap, field));
        Operator operator = this.allowedOperator(op, meta.getOnlyOn());
        if (operator == null) {
            return null;
        }
        if (op != null && (operator == Operator.Empty || operator == Operator.NotEmpty)) {
            return new FieldParam(field, operator);
        }
        if ((indices == null || indices.isEmpty()) && param == null) {
            return null;
        }
        ArrayList<FieldParam.Value> arrayList = values = param != null ? param.getValueList() : new ArrayList<FieldParam.Value>();
        if (values.isEmpty() && indices != null) {
            for (int index : indices) {
                Object value = paraMap.get(field + this.separator + index);
                if (index == 0 && value == null) {
                    value = paraMap.get(field);
                }
                values.add(new FieldParam.Value(value, index));
            }
        }
        if (this.isAllEmpty(values)) {
            return null;
        }
        Boolean ignoreCase = null;
        if (param != null) {
            ignoreCase = param.isIgnoreCase();
        }
        if (ignoreCase == null) {
            ignoreCase = ObjectUtils.toBoolean(paraMap.get(field + this.separator + this.ignoreCaseSuffix));
        }
        return new FieldParam(field, operator, values, ignoreCase);
    }

    private boolean isAllEmpty(List<FieldParam.Value> values) {
        for (FieldParam.Value value : values) {
            if (value.isEmptyValue()) continue;
            return false;
        }
        return true;
    }

    private Operator toOperator(String field, Map<String, Object> paraMap, FieldParam param) {
        Operator op;
        if (param != null && (op = param.getOperator()) != null) {
            return op;
        }
        Object value = paraMap.get(field + this.separator + this.operatorSuffix);
        if (value instanceof Operator) {
            return (Operator)((Object)value);
        }
        if (value instanceof String) {
            return Operator.from((String)value);
        }
        return null;
    }

    protected Operator allowedOperator(Operator op, Operator[] onlyOn) {
        if (op == null) {
            if (onlyOn.length == 0) {
                return Operator.Equal;
            }
            return onlyOn[0];
        }
        if (onlyOn.length == 0) {
            return op;
        }
        for (Operator o : onlyOn) {
            if (o != op) continue;
            return op;
        }
        return null;
    }

    private OrderBy resolveOrderBy(Set<String> fieldSet, Map<String, Object> paraMap) {
        String sort = ObjectUtils.string(paraMap.get(this.sortName));
        String order = ObjectUtils.string(paraMap.get(this.orderName));
        if (sort != null && fieldSet.contains(sort)) {
            if ("asc".equalsIgnoreCase(order)) {
                return new OrderBy(sort, "asc");
            }
            if ("desc".equalsIgnoreCase(order)) {
                return new OrderBy(sort, "desc");
            }
            return new OrderBy(sort, null);
        }
        return null;
    }

    public PageExtractor getPageExtractor() {
        return this.pageExtractor;
    }

    public void setPageExtractor(PageExtractor pageExtractor) {
        this.pageExtractor = Objects.requireNonNull(pageExtractor);
    }

    public void setParamFilters(ParamFilter[] paramFilters) {
        this.paramFilters = Objects.requireNonNull(paramFilters);
    }

    public ParamFilter[] getParamFilters() {
        return this.paramFilters;
    }

    public String getSortName() {
        return this.sortName;
    }

    public void setSortName(String sortName) {
        this.sortName = Objects.requireNonNull(sortName);
    }

    public String getOrderName() {
        return this.orderName;
    }

    public void setOrderName(String orderName) {
        this.orderName = Objects.requireNonNull(orderName);
    }

    public String getIgnoreCaseSuffix() {
        return this.ignoreCaseSuffix;
    }

    public void setIgnoreCaseSuffix(String ignoreCaseSuffix) {
        this.ignoreCaseSuffix = Objects.requireNonNull(ignoreCaseSuffix);
    }

    public String getOperatorSuffix() {
        return this.operatorSuffix;
    }

    public void setOperatorSuffix(String operatorSuffix) {
        this.operatorSuffix = Objects.requireNonNull(operatorSuffix);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = Objects.requireNonNull(separator);
    }

    public String getOnlySelectName() {
        return this.onlySelectName;
    }

    public void setOnlySelectName(String onlySelectName) {
        this.onlySelectName = Objects.requireNonNull(onlySelectName);
    }

    public String getSelectExcludeName() {
        return this.selectExcludeName;
    }

    public void setSelectExcludeName(String selectExcludeName) {
        this.selectExcludeName = Objects.requireNonNull(selectExcludeName);
    }
}

