/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SnippetResolver;
import com.ejlchina.searcher.SqlSnippet;
import com.ejlchina.searcher.util.StringUtils;

public class DefaultSnippetResolver
implements SnippetResolver {
    private String paramPrefix = ":";
    private String[] paramEndFlags = new String[]{" ", "\t", "\n", "\r", "+", "-", "*", "/", "=", "!", ">", "<", ",", ")", "'", "%"};
    private final char[] quotations = new char[]{'\'', '\"'};

    @Override
    public SqlSnippet resolve(String fragment) {
        SqlSnippet sqlSnippet = this.newSqlSnippet();
        int index1 = fragment.indexOf(this.paramPrefix);
        while (index1 >= 0) {
            int index2 = this.findParamEndIndex(fragment, index1);
            String sqlName = this.getSqlName(fragment, index1, index2);
            if (StringUtils.isBlank(sqlName) || sqlName.length() < 2) {
                throw new SearchException("There is a syntax error about embed param: " + fragment);
            }
            SqlSnippet.Param param = this.newSqlSnippetParam(sqlName);
            boolean endWithPrefix = sqlName.endsWith(this.paramPrefix);
            if (endWithPrefix) {
                param.setName(sqlName.substring(1, sqlName.length() - this.paramPrefix.length()));
            } else {
                param.setName(sqlName.substring(1));
            }
            int quotationCount1 = StringUtils.containCount(fragment, 0, index1, this.quotations);
            int quotationCount2 = StringUtils.containCount(fragment, Math.max(index1, index2), fragment.length(), this.quotations);
            if ((quotationCount1 + quotationCount2) % 2 != 0) {
                throw new SearchException("There is a syntax error (quotations mismatch): " + fragment);
            }
            int nextIndex = index1 + sqlName.length();
            if (quotationCount1 % 2 == 0 && !endWithPrefix) {
                param.setJdbcPara(true);
                fragment = fragment.replaceFirst(sqlName, "?");
                nextIndex = nextIndex - sqlName.length() + 1;
            }
            sqlSnippet.addParam(param);
            index1 = fragment.indexOf(this.paramPrefix, nextIndex);
        }
        sqlSnippet.setSnippet(fragment);
        return sqlSnippet;
    }

    protected SqlSnippet newSqlSnippet() {
        return new SqlSnippet();
    }

    protected SqlSnippet.Param newSqlSnippetParam(String sqlName) {
        return new SqlSnippet.Param(sqlName);
    }

    private String getSqlName(String sqlSnippet, int index1, int index2) {
        if (index2 > 0) {
            return sqlSnippet.substring(index1, index2);
        }
        return sqlSnippet.substring(index1);
    }

    private int findParamEndIndex(String sqlSnippet, int fromIndex) {
        int index = -1;
        for (String flag : this.paramEndFlags) {
            int index0 = sqlSnippet.indexOf(flag, fromIndex);
            if (index < 0) {
                index = index0;
                continue;
            }
            if (index0 <= 0) continue;
            index = Math.min(index, index0);
        }
        return index;
    }

    public String getParamPrefix() {
        return this.paramPrefix;
    }

    public void setParamPrefix(String paramPrefix) {
        this.paramPrefix = paramPrefix;
    }

    public String[] getParamEndFlags() {
        return this.paramEndFlags;
    }

    public void setParamEndFlags(String[] paramEndFlags) {
        this.paramEndFlags = paramEndFlags;
    }

    public char[] getQuotations() {
        return this.quotations;
    }
}

