/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.searcher.implement;

import com.ejlchina.searcher.BeanMeta;
import com.ejlchina.searcher.FieldMeta;
import com.ejlchina.searcher.SearchException;
import com.ejlchina.searcher.SearchParam;
import com.ejlchina.searcher.SearchSql;
import com.ejlchina.searcher.SqlResolver;
import com.ejlchina.searcher.SqlSnippet;
import com.ejlchina.searcher.dialect.Dialect;
import com.ejlchina.searcher.dialect.MySqlDialect;
import com.ejlchina.searcher.implement.DateValueCorrector;
import com.ejlchina.searcher.param.FetchType;
import com.ejlchina.searcher.param.FieldParam;
import com.ejlchina.searcher.param.Operator;
import com.ejlchina.searcher.param.OrderBy;
import com.ejlchina.searcher.util.ObjectUtils;
import com.ejlchina.searcher.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class DefaultSqlResolver
implements SqlResolver {
    private Dialect dialect = new MySqlDialect();
    private DateValueCorrector dateValueCorrector = new DateValueCorrector();

    public DefaultSqlResolver() {
    }

    public DefaultSqlResolver(Dialect dialect, DateValueCorrector dateValueCorrector) {
        this.dialect = dialect;
        this.dateValueCorrector = dateValueCorrector;
    }

    @Override
    public <T> SearchSql<T> resolve(BeanMeta<T> beanMeta, SearchParam searchParam) {
        String fromWhereSql;
        List<String> fetchFields = searchParam.getFetchFields();
        SearchSql<T> searchSql = new SearchSql<T>(beanMeta, fetchFields);
        FetchType fetchType = searchParam.getFetchType();
        searchSql.setShouldQueryCluster(fetchType.shouldQueryCluster());
        searchSql.setShouldQueryList(fetchType.shouldQueryList());
        StringBuilder builder = new StringBuilder("select ");
        if (beanMeta.isDistinct()) {
            builder.append("distinct ");
        }
        int fieldCount = fetchFields.size();
        for (int i = 0; i < fieldCount; ++i) {
            String field = fetchFields.get(i);
            FieldMeta meta = beanMeta.requireFieldMeta(field);
            String dbField = this.resolveDbField(meta.getFieldSql(), searchParam, searchSql, beanMeta.isDistinct());
            builder.append(dbField).append(" ").append(meta.getDbAlias());
            if (i >= fieldCount - 1) continue;
            builder.append(", ");
        }
        String fieldSelectSql = builder.toString();
        builder = new StringBuilder(" from ").append(this.resolveTables(beanMeta.getTableSnippet(), searchParam, searchSql));
        String joinCond = beanMeta.getJoinCond();
        boolean hasJoinCond = StringUtils.isNotBlank(joinCond);
        List<FieldParam> fieldParamList = searchParam.getFieldParams();
        if (hasJoinCond || fieldParamList.size() > 0) {
            builder.append(" where (");
            if (hasJoinCond) {
                List<SqlSnippet.Param> joinCondParams = beanMeta.getJoinCondEmbedParams();
                if (joinCondParams != null) {
                    for (SqlSnippet.Param param : joinCondParams) {
                        Object sqlParam = searchParam.getPara(param.getName());
                        if (param.isJdbcPara()) {
                            searchSql.addListSqlParam(sqlParam);
                            searchSql.addClusterSqlParam(sqlParam);
                            continue;
                        }
                        String strParam = sqlParam != null ? sqlParam.toString() : "";
                        joinCond = joinCond.replace(param.getSqlName(), strParam);
                    }
                }
                builder.append(joinCond).append(")");
            }
        }
        for (int i = 0; i < fieldParamList.size(); ++i) {
            if (i > 0 || hasJoinCond) {
                builder.append(" and (");
            }
            FieldParam fieldParam = fieldParamList.get(i);
            String fieldName = fieldParam.getName();
            FieldMeta meta = beanMeta.requireFieldMeta(fieldName);
            List<Object> sqlParams = this.appendFilterConditionSql(builder, meta.getType(), meta.getFieldSql().getSnippet(), fieldParam);
            for (Object sqlParam : sqlParams) {
                searchSql.addListSqlParam(sqlParam);
                searchSql.addClusterSqlParam(sqlParam);
            }
            builder.append(")");
        }
        String groupBy = beanMeta.getGroupBy();
        String[] summaryFields = fetchType.getSummaryFields();
        boolean shouldQueryTotal = fetchType.shouldQueryTotal();
        if (StringUtils.isBlank(groupBy)) {
            if (shouldQueryTotal || summaryFields.length > 0) {
                Object clusterSelectSql;
                if (beanMeta.isDistinct()) {
                    String originalSql = fieldSelectSql + builder;
                    clusterSelectSql = this.resolveClusterSelectSql(searchSql, summaryFields, shouldQueryTotal, originalSql);
                    String tableAlias = this.generateTableAlias(originalSql);
                    searchSql.setClusterSqlString((String)clusterSelectSql + " from (" + originalSql + ") " + tableAlias);
                } else {
                    String fromWhereSql2 = builder.toString();
                    clusterSelectSql = this.resolveClusterSelectSql(searchSql, summaryFields, shouldQueryTotal, fromWhereSql2);
                    searchSql.setClusterSqlString((String)clusterSelectSql + fromWhereSql2);
                }
            }
        } else {
            List<SqlSnippet.Param> groupParams = beanMeta.getGroupByEmbedParams();
            if (groupParams != null) {
                for (SqlSnippet.Param param : groupParams) {
                    Object sqlParam;
                    sqlParam = searchParam.getPara(param.getName());
                    if (param.isJdbcPara()) {
                        searchSql.addListSqlParam(sqlParam);
                        searchSql.addClusterSqlParam(sqlParam);
                        continue;
                    }
                    String strParam = sqlParam != null ? sqlParam.toString() : "";
                    groupBy = groupBy.replace(param.getSqlName(), strParam);
                }
            }
            builder.append(" group by ").append(groupBy);
            if (shouldQueryTotal || summaryFields.length > 0) {
                fromWhereSql = builder.toString();
                if (beanMeta.isDistinct()) {
                    String originalSql = fieldSelectSql + fromWhereSql;
                    String clusterSelectSql = this.resolveClusterSelectSql(searchSql, summaryFields, shouldQueryTotal, originalSql);
                    String tableAlias = this.generateTableAlias(originalSql);
                    searchSql.setClusterSqlString(clusterSelectSql + " from (" + originalSql + ") " + tableAlias);
                } else {
                    String clusterSelectSql = this.resolveClusterSelectSql(searchSql, summaryFields, shouldQueryTotal, fromWhereSql);
                    String tableAlias = this.generateTableAlias(fromWhereSql);
                    searchSql.setClusterSqlString(clusterSelectSql + " from (select count(*) " + fromWhereSql + ") " + tableAlias);
                }
            }
        }
        if (fetchType.shouldQueryList()) {
            OrderBy orderBy = searchParam.getOrderBy();
            if (orderBy != null) {
                FieldMeta meta = beanMeta.requireFieldMeta(orderBy.getSort());
                builder.append(" order by ").append(meta.getDbAlias());
                String order = orderBy.getOrder();
                if (order != null) {
                    builder.append(" ").append(order);
                }
            }
            fromWhereSql = builder.toString();
            Dialect.PaginateSql paginateSql = this.dialect.forPaginate(fieldSelectSql, fromWhereSql, searchParam.getPaging());
            searchSql.setListSqlString(paginateSql.getSql());
            searchSql.addListSqlParams(paginateSql.getParams());
        }
        return searchSql;
    }

    private <T> String resolveTables(SqlSnippet tableSnippet, SearchParam searchParam, SearchSql<T> searchSql) {
        String tables = tableSnippet.getSnippet();
        List<SqlSnippet.Param> params = tableSnippet.getParams();
        for (SqlSnippet.Param param : params) {
            Object sqlParam = searchParam.getPara(param.getName());
            if (param.isJdbcPara()) {
                searchSql.addListSqlParam(sqlParam);
                searchSql.addClusterSqlParam(sqlParam);
                continue;
            }
            String strParam = sqlParam != null ? sqlParam.toString() : "";
            tables = tables.replace(param.getSqlName(), strParam);
        }
        return tables;
    }

    private <T> String resolveDbField(SqlSnippet dbFieldSnippet, SearchParam searchParam, SearchSql<T> searchSql, boolean distinct) {
        String dbField = dbFieldSnippet.getSnippet();
        List<SqlSnippet.Param> params = dbFieldSnippet.getParams();
        for (SqlSnippet.Param param : params) {
            Object sqlParam = searchParam.getPara(param.getName());
            if (param.isJdbcPara()) {
                searchSql.addListSqlParam(sqlParam);
                if (!distinct) continue;
                searchSql.addClusterSqlParam(sqlParam);
                continue;
            }
            String strParam = sqlParam != null ? sqlParam.toString() : "";
            dbField = dbField.replace(param.getSqlName(), strParam);
        }
        return dbField;
    }

    private <T> String resolveClusterSelectSql(SearchSql<T> searchSql, String[] summaryFields, boolean shouldQueryTotal, String originalSql) {
        StringBuilder clusterSelectSqlBuilder = new StringBuilder("select ");
        if (shouldQueryTotal) {
            String countAlias = this.generateColumnAlias("count", originalSql);
            clusterSelectSqlBuilder.append("count(*) ").append(countAlias);
            searchSql.setCountAlias(countAlias);
        }
        if (summaryFields != null) {
            BeanMeta<T> beanMeta = searchSql.getBeanMeta();
            if (shouldQueryTotal && summaryFields.length > 0) {
                clusterSelectSqlBuilder.append(", ");
            }
            for (int i = 0; i < summaryFields.length; ++i) {
                String summaryField = summaryFields[i];
                String summaryAlias = this.generateColumnAlias(summaryField, originalSql);
                String fieldSql = beanMeta.getFieldSql(summaryField);
                if (fieldSql == null) {
                    throw new SearchException("\u6c42\u548c\u5c5e\u6027\u3010" + summaryField + "\u3011\u6ca1\u6709\u548c\u6570\u636e\u5e93\u5b57\u6bb5\u505a\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u8be5\u5c5e\u6027\u662f\u5426\u88ab @DbField \u6b63\u786e\u6ce8\u89e3\uff01");
                }
                clusterSelectSqlBuilder.append("sum(").append(fieldSql).append(") ").append(summaryAlias);
                if (i < summaryFields.length - 1) {
                    clusterSelectSqlBuilder.append(", ");
                }
                searchSql.addSummaryAlias(summaryAlias);
            }
        }
        return clusterSelectSqlBuilder.toString();
    }

    private String generateTableAlias(String originalSql) {
        return this.generateAlias("t_", originalSql);
    }

    private String generateColumnAlias(String seed, String originalSql) {
        return this.generateAlias("_" + seed, originalSql);
    }

    private String generateAlias(String seed, String originalSql) {
        int index = 0;
        String tableAlias = seed;
        while (originalSql.contains(tableAlias)) {
            tableAlias = seed + index++;
        }
        return tableAlias;
    }

    private List<Object> appendFilterConditionSql(StringBuilder builder, Class<?> fieldType, String dbField, FieldParam fieldParam) {
        Object[] values = fieldParam.getValues();
        boolean ignoreCase = fieldParam.isIgnoreCase();
        Operator operator = fieldParam.getOperator();
        if (Date.class.isAssignableFrom(fieldType)) {
            values = this.dateValueCorrector.correct(values, operator);
        }
        if (ignoreCase) {
            this.dialect.toUpperCase(builder, dbField);
            values = this.toUpperCase(values);
        } else {
            builder.append(dbField);
        }
        Object firstRealValue = ObjectUtils.firstNotNull(values);
        ArrayList<Object> params = new ArrayList<Object>(2);
        switch (operator) {
            case Like: {
                builder.append(" like ?");
                params.add("%" + firstRealValue + "%");
                break;
            }
            case Equal: {
                builder.append(" = ?");
                params.add(firstRealValue);
                break;
            }
            case GreaterEqual: {
                builder.append(" >= ?");
                params.add(firstRealValue);
                break;
            }
            case GreaterThan: {
                builder.append(" > ?");
                params.add(firstRealValue);
                break;
            }
            case LessEqual: {
                builder.append(" <= ?");
                params.add(firstRealValue);
                break;
            }
            case LessThan: {
                builder.append(" < ?");
                params.add(firstRealValue);
                break;
            }
            case NotEqual: {
                builder.append(" != ?");
                params.add(firstRealValue);
                break;
            }
            case Empty: {
                builder.append(" is null or ").append(dbField).append(" = ''");
                break;
            }
            case NotEmpty: {
                builder.append(" is not null and ").append(dbField).append(" != ''");
                break;
            }
            case StartWith: {
                builder.append(" like ?");
                params.add(firstRealValue + "%");
                break;
            }
            case EndWith: {
                builder.append(" like ?");
                params.add("%" + firstRealValue);
                break;
            }
            case Between: {
                Object value1;
                boolean val1Null = false;
                boolean val2Null = false;
                Object value0 = values.length > 0 ? values[0] : null;
                Object object = value1 = values.length > 1 ? values[1] : null;
                if (value0 == null || value0 instanceof String && StringUtils.isBlank((String)value0)) {
                    val1Null = true;
                }
                if (value1 == null || value1 instanceof String && StringUtils.isBlank((String)value1)) {
                    val2Null = true;
                }
                if (!val1Null && !val2Null) {
                    builder.append(" between ? and ? ");
                    params.add(value0);
                    params.add(value1);
                    break;
                }
                if (val1Null && !val2Null) {
                    builder.append(" <= ? ");
                    params.add(value1);
                    break;
                }
                if (val1Null) break;
                builder.append(" >= ? ");
                params.add(value0);
                break;
            }
            case MultiValue: {
                builder.append(" in (");
                for (int i = 0; i < values.length; ++i) {
                    builder.append("?");
                    params.add(values[i]);
                    if (i >= values.length - 1) continue;
                    builder.append(", ");
                }
                builder.append(")");
            }
        }
        return params;
    }

    public Object[] toUpperCase(Object[] params) {
        for (int i = 0; i < params.length; ++i) {
            Object val = params[i];
            if (val == null) continue;
            params[i] = val instanceof String ? ((String)val).toUpperCase() : val;
        }
        return params;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = Objects.requireNonNull(dialect);
    }

    public DateValueCorrector getDateValueCorrector() {
        return this.dateValueCorrector;
    }

    public void setDateValueCorrector(DateValueCorrector dateValueCorrector) {
        this.dateValueCorrector = Objects.requireNonNull(dateValueCorrector);
    }
}

