/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.data;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.ejlchina.data.Array;
import com.ejlchina.data.DataConvertor;
import com.ejlchina.data.FastjsonArray;
import com.ejlchina.data.FastjsonMapper;
import com.ejlchina.data.Mapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;

public class FastjsonDataConvertor
implements DataConvertor {
    public Mapper toMapper(InputStream in, Charset charset) {
        return new FastjsonMapper(JSON.parseObject((String)this.toString(in, charset)));
    }

    public Array toArray(InputStream in, Charset charset) {
        return new FastjsonArray(JSON.parseArray((String)this.toString(in, charset)));
    }

    public byte[] serialize(Object object, Charset charset) {
        if (object instanceof FastjsonMapper || object instanceof FastjsonArray) {
            return object.toString().getBytes(charset);
        }
        return JSON.toJSONString((Object)object).getBytes(charset);
    }

    public <T> T toBean(Type type, InputStream in, Charset charset) {
        try {
            return (T)JSON.parseObject((InputStream)in, (Charset)charset, (Type)type, (Feature[])new Feature[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> List<T> toList(Class<T> type, InputStream in, Charset charset) {
        return JSON.parseArray((String)this.toString(in, charset), type);
    }

    protected String toString(InputStream in, Charset charset) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buff = new byte[512];
        try {
            int len;
            while ((len = in.read(buff)) > 0) {
                output.write(buff, 0, len);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        try {
            return output.toString(charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

