/*
 * Decompiled with CFR 0.152.
 */
package com.ejlchina.data;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlUtils {
    public static List<Element> children(Element element) {
        NodeList nodes = element.getChildNodes();
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            list.add((Element)node);
        }
        return list;
    }

    public static Element findElement(List<Element> nodes, String[] nameKeys, String key) {
        for (Element node : nodes) {
            if (!XmlUtils.nodeNameEquals(node, key)) continue;
            return node;
        }
        for (String nameKey : nameKeys) {
            for (Element node : nodes) {
                if (!XmlUtils.elementKeyEquals(node, nameKey, key)) continue;
                return node;
            }
        }
        return null;
    }

    public static List<Element> findElements(List<Element> nodes, String[] nameKeys, String key) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element node : nodes) {
            if (!XmlUtils.nodeNameEquals(node, key)) continue;
            elements.add(node);
        }
        if (elements.size() > 0) {
            return elements;
        }
        for (String nameKey : nameKeys) {
            for (Element node : nodes) {
                if (!XmlUtils.elementKeyEquals(node, nameKey, key)) continue;
                elements.add(node);
            }
            if (elements.size() <= 0) continue;
            return elements;
        }
        return elements;
    }

    public static String value(Element node, String[] valueKeys) {
        for (String valueKey : valueKeys) {
            String value = node.getAttribute(valueKey);
            if (XmlUtils.isBlank(value)) continue;
            return value;
        }
        return node.getTextContent();
    }

    public static boolean nodeNameEquals(Node node, String name) {
        String nodeName = node.getNodeName();
        return XmlUtils.nameEquals(name, nodeName);
    }

    public static boolean elementKeyEquals(Element node, String key, String name) {
        String nodeName = node.getAttribute(key);
        return XmlUtils.nameEquals(name, nodeName);
    }

    private static boolean nameEquals(String name, String nodeName) {
        return nodeName.equals(name) || XmlUtils.toCamera(nodeName, "-", true).equals(name) || XmlUtils.toCamera(nodeName, "_", true).equals(name);
    }

    public static String toCamera(String src, String hyphenation, boolean initLetterLower) {
        if (XmlUtils.isBlank(src)) {
            return src;
        }
        StringBuilder sb = new StringBuilder();
        String[] list = src.split(hyphenation);
        for (int i = 0; i < list.length; ++i) {
            if (i == 0 && initLetterLower) {
                sb.append(XmlUtils.firstCharToLowerCase(list[i]));
                continue;
            }
            sb.append(XmlUtils.firstCharToUpperCase(list[i]));
        }
        return sb.toString();
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean toBoolean(String s) {
        return s != null && (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes") || s.equalsIgnoreCase("on") || s.equalsIgnoreCase("y") || s.equalsIgnoreCase("t"));
    }

    public static int toInt(String s) {
        if (s != null) {
            try {
                s = s.replace(",", "");
                if (s.startsWith("0x")) {
                    return Integer.parseInt(s.substring(2), 16);
                }
                if (s.startsWith("0b")) {
                    return Integer.parseInt(s.substring(2), 2);
                }
                if (s.startsWith("0") && !s.startsWith("0.")) {
                    return Integer.parseInt(s.substring(1), 8);
                }
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("\u65e0\u6cd5\u5c06\u5b57\u7b26\u4e32\"" + s + "\"\u8f6c\u6362\u4e3a Int \u6570\u5b57", e);
            }
        }
        return 0;
    }

    public static long toLong(String s) {
        if (s != null) {
            try {
                s = s.replace(",", "");
                if (s.startsWith("0x")) {
                    return Long.parseLong(s.substring(2), 16);
                }
                if (s.startsWith("0b")) {
                    return Long.parseLong(s.substring(2), 2);
                }
                if (s.startsWith("0") && !s.startsWith("0.")) {
                    return Long.parseLong(s.substring(1), 8);
                }
                return Long.parseLong(s);
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("\u65e0\u6cd5\u5c06\u5b57\u7b26\u4e32\"" + s + "\"\u8f6c\u6362\u4e3a Long \u6570\u5b57", e);
            }
        }
        return 0L;
    }

    public static float toFloat(String s) {
        if (s != null) {
            try {
                return Float.parseFloat(s.replace(",", ""));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("\u65e0\u6cd5\u5c06\u5b57\u7b26\u4e32\"" + s + "\"\u8f6c\u6362\u4e3a Float \u6570\u5b57", e);
            }
        }
        return 0.0f;
    }

    public static double toDouble(String s) {
        if (s != null) {
            try {
                return Double.parseDouble(s.replace(",", ""));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("\u65e0\u6cd5\u5c06\u5b57\u7b26\u4e32\"" + s + "\"\u8f6c\u6362\u4e3a Float \u6570\u5b57", e);
            }
        }
        return 0.0;
    }
}

