/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.config.impl;

import cn.binarywang.wx.miniapp.config.impl.AbstractWxMaRedisConfig;
import org.apache.commons.lang3.builder.ToStringBuilder;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class WxMaRedisConfigImpl
extends AbstractWxMaRedisConfig {
    private JedisPool jedisPool;
    private static final String ACCESS_TOKEN_KEY = "wa:access_token:";
    private String accessTokenKey;

    @Deprecated
    public WxMaRedisConfigImpl() {
    }

    public WxMaRedisConfigImpl(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Deprecated
    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    protected Jedis getJedis() {
        return this.jedisPool.getResource();
    }

    @Override
    public void setAppid(String appId) {
        super.setAppid(appId);
        this.accessTokenKey = ACCESS_TOKEN_KEY.concat(appId);
    }

    @Override
    public String getAccessToken() {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.get(this.accessTokenKey);
            return string;
        }
    }

    @Override
    public boolean isAccessTokenExpired() {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.ttl(this.accessTokenKey) < 2L;
            return bl;
        }
    }

    @Override
    public synchronized void updateAccessToken(String accessToken, int expiresInSeconds) {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.setex(this.accessTokenKey, expiresInSeconds - 200, accessToken);
        }
    }

    @Override
    public void expireAccessToken() {
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.expire(this.accessTokenKey, 0);
        }
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

