/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielwegener.logback.kafka.encoding;

import ch.qos.logback.core.Layout;
import com.github.danielwegener.logback.kafka.encoding.KafkaMessageEncoderBase;
import java.nio.charset.Charset;

public class LayoutKafkaMessageEncoder<E>
extends KafkaMessageEncoderBase<E> {
    private Layout<E> layout;
    private Charset charset;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    public LayoutKafkaMessageEncoder() {
    }

    public LayoutKafkaMessageEncoder(Layout<E> layout, Charset charset) {
        this.layout = layout;
        this.charset = charset;
    }

    @Override
    public void start() {
        if (this.charset == null) {
            this.addInfo("No charset specified for PatternLayoutKafkaEncoder. Using default UTF8 encoding.");
            this.charset = UTF8;
        }
        super.start();
    }

    @Override
    public byte[] doEncode(E event) {
        String message = this.layout.doLayout(event);
        return message.getBytes(this.charset);
    }

    public void setLayout(Layout<E> layout) {
        this.layout = layout;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Layout<E> getLayout() {
        return this.layout;
    }

    public Charset getCharset() {
        return this.charset;
    }
}

