/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.cglib.proxy;

import com.github.drinkjava2.asm.Label;
import com.github.drinkjava2.asm.Type;
import com.github.drinkjava2.cglib.core.ClassEmitter;
import com.github.drinkjava2.cglib.core.CodeEmitter;
import com.github.drinkjava2.cglib.core.Constants;
import com.github.drinkjava2.cglib.core.MethodInfo;
import com.github.drinkjava2.cglib.core.Signature;
import com.github.drinkjava2.cglib.core.TypeUtils;
import com.github.drinkjava2.cglib.proxy.CallbackGenerator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

class LazyLoaderGenerator
implements CallbackGenerator {
    public static final LazyLoaderGenerator INSTANCE = new LazyLoaderGenerator();
    private static final Signature LOAD_OBJECT = TypeUtils.parseSignature("Object loadObject()");
    private static final Type LAZY_LOADER = TypeUtils.parseType("com.github.drinkjava2.cglib.proxy.LazyLoader");

    LazyLoaderGenerator() {
    }

    @Override
    public void generate(ClassEmitter ce, CallbackGenerator.Context context, List methods) {
        CodeEmitter e;
        HashSet<Integer> indexes = new HashSet<Integer>();
        for (MethodInfo method : methods) {
            if (TypeUtils.isProtected(method.getModifiers())) continue;
            int index = context.getIndex(method);
            indexes.add(new Integer(index));
            e = context.beginMethod(ce, method);
            e.load_this();
            e.dup();
            e.invoke_virtual_this(this.loadMethod(index));
            e.checkcast(method.getClassInfo().getType());
            e.load_args();
            e.invoke(method);
            e.return_value();
            e.end_method();
        }
        Iterator it = indexes.iterator();
        while (it.hasNext()) {
            int index = (Integer)it.next();
            String delegate = "CGLIB$LAZY_LOADER_" + index;
            ce.declare_field(2, delegate, Constants.TYPE_OBJECT, null);
            e = ce.begin_method(50, this.loadMethod(index), null);
            e.load_this();
            e.getfield(delegate);
            e.dup();
            Label end = e.make_label();
            e.ifnonnull(end);
            e.pop();
            e.load_this();
            context.emitCallback(e, index);
            e.invoke_interface(LAZY_LOADER, LOAD_OBJECT);
            e.dup_x1();
            e.putfield(delegate);
            e.mark(end);
            e.return_value();
            e.end_method();
        }
    }

    private Signature loadMethod(int index) {
        return new Signature("CGLIB$LOAD_PRIVATE_" + index, Constants.TYPE_OBJECT, Constants.TYPES_EMPTY);
    }

    @Override
    public void generateStatic(CodeEmitter e, CallbackGenerator.Context context, List methods) {
    }
}

