/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jbeanbox;

import com.github.drinkjava2.jbeanbox.AopUtils;
import com.github.drinkjava2.jbeanbox.BeanBox;
import com.github.drinkjava2.jbeanbox.BeanBoxException;
import com.github.drinkjava2.jbeanbox.BeanBoxUtils;
import com.github.drinkjava2.jbeanbox.ClassScanner;
import com.github.drinkjava2.jbeanbox.EMPTY;
import com.github.drinkjava2.jbeanbox.NameMatchUtil;
import com.github.drinkjava2.jbeanbox.PrototypeBean;
import com.github.drinkjava2.jbeanbox.ReflectionUtils;
import com.github.drinkjava2.jbeanbox.ValueTranslator;
import com.github.drinkjava2.jbeanbox.annotation.AOP;
import com.github.drinkjava2.jbeanbox.annotation.COMPONENT;
import com.github.drinkjava2.jbeanbox.annotation.INJECT;
import com.github.drinkjava2.jbeanbox.annotation.NAMED;
import com.github.drinkjava2.jbeanbox.annotation.POSTCONSTRUCT;
import com.github.drinkjava2.jbeanbox.annotation.PREDESTROY;
import com.github.drinkjava2.jbeanbox.annotation.PROTOTYPE;
import com.github.drinkjava2.jbeanbox.annotation.QUALIFILER;
import com.github.drinkjava2.jbeanbox.annotation.VALUE;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Qualifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

public class BeanBoxContext {
    protected boolean allowAnnotation = true;
    protected boolean allowSpringJsrAnnotation = true;
    protected ValueTranslator valueTranslator = new ValueTranslator.DefaultValueTranslator();
    protected Map<Object, Object> bindCache = new ConcurrentHashMap<Object, Object>();
    protected Map<Class<?>, BeanBox> beanBoxCache = new ConcurrentHashMap();
    protected Map<Object, Object> singletonCache = new ConcurrentHashMap<Object, Object>();
    protected Set<Class<?>> componentCache = new HashSet();
    protected Map<String, BeanBox> componentSearchCache = new ConcurrentHashMap<String, BeanBox>();
    protected static BeanBoxContext globalBeanBoxContext = new BeanBoxContext();
    protected List<Object[]> aopRules;
    private static final BeanBox NO_THIS_COMPONENT = new BeanBox();

    public BeanBoxContext() {
        this.bindBasicTypes();
    }

    public void reset() {
        for (Map.Entry<Object, Object> singletons : this.singletonCache.entrySet()) {
            BeanBox box;
            Object key = singletons.getKey();
            Object obj = singletons.getValue();
            if (!(key instanceof BeanBox) || (box = (BeanBox)key).getPreDestroy() == null) continue;
            try {
                box.getPreDestroy().invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        this.bindCache.clear();
        this.beanBoxCache.clear();
        this.singletonCache.clear();
        this.componentCache.clear();
        this.componentSearchCache.clear();
        this.allowAnnotation = true;
        this.allowSpringJsrAnnotation = true;
        this.valueTranslator = new ValueTranslator.DefaultValueTranslator();
        this.bindBasicTypes();
    }

    public Object getObject(Object target) {
        return this.getBean(target, true, null);
    }

    public <T> T getBean(Object target) {
        return this.getBean(target, true, null);
    }

    public <T> T getInstance(Class<T> target) {
        return this.getBean(target, true, null);
    }

    public <T> T getBean(Object target, boolean required) {
        return this.getBean(target, required, null);
    }

    public <T> T getInstance(Class<T> target, boolean required) {
        return this.getBean(target, required, null);
    }

    public BeanBox getSingletonBeanBox(Class<?> clazz) {
        return this.getBeanBox(clazz, true);
    }

    public BeanBox getPrototypeBeanBox(Class<?> clazz) {
        return this.getBeanBox(clazz, false);
    }

    public BeanBox getBeanBox(Class<?> clazz) {
        return this.getBeanBox(clazz, null);
    }

    public <T> T getBean(Object target, boolean required, Set<Object> history) {
        if (target != null && this.singletonCache.containsKey(target)) {
            return (T)this.singletonCache.get(target);
        }
        if (target == null || EMPTY.class == target) {
            return (T)BeanBoxContext.notfoundOrException(target, required, null);
        }
        if (history != null && target instanceof BeanBox && history.contains(target)) {
            BeanBoxException.throwEX("Circular dependency found on :" + target);
        }
        Object result = null;
        if (history == null) {
            history = new HashSet<Object>();
        }
        history.add(target);
        if (this.bindCache.containsKey(target)) {
            result = this.getBean(this.bindCache.get(target), required, history);
        } else if (target instanceof BeanBox) {
            result = this.getBeanFromBox((BeanBox)target, required, history);
        } else if (target instanceof Class) {
            BeanBox box = this.getBeanBox((Class)target);
            BeanBox bx = this.searchComponent(box);
            result = bx != null ? this.getBean(bx, required, history) : this.getBean(box, required, history);
            if (EMPTY.class != result && box.isSingleton()) {
                this.singletonCache.put(target, result);
            }
        } else {
            result = BeanBoxContext.notfoundOrException(target, required, null);
        }
        history.remove(target);
        return (T)result;
    }

    public void scanComponents(String ... packages) {
        List<Class> classes = ClassScanner.scanPackages(packages);
        for (Class claz : classes) {
            for (Annotation anno : claz.getAnnotations()) {
                Class<? extends Annotation> aType = anno.annotationType();
                if (!BeanBoxUtils.ifSameOrChildAnno(aType, COMPONENT.class) && (!this.allowSpringJsrAnnotation || !BeanBoxUtils.ifSameOrChildAnno(aType, Component.class))) continue;
                this.componentCache.add(claz);
                BeanBox box = this.getBeanBox(claz);
                Map<String, Object> values = BeanBoxUtils.changeAnnotationValuesToMap(anno);
                if (!"".equals(values.get("value"))) {
                    this.bind(values.get("value"), box);
                    continue;
                }
                String s = claz.getSimpleName();
                this.bind(s, box);
                if (Character.isLowerCase(s.charAt(0))) continue;
                s = Character.toLowerCase(s.charAt(0)) + s.substring(1);
                this.bind(s, box);
            }
        }
    }

    public BeanBoxContext bind(Object id, Object target) {
        BeanBoxException.assureNotNull(id, "bind id can not be empty");
        this.bindCache.put(id, target);
        return this;
    }

    public BeanBoxContext addContextAop(Object aop, String classNameRegex, String methodNameRegex) {
        if (this.aopRules == null) {
            this.aopRules = new ArrayList<Object[]>();
        }
        this.aopRules.add(new Object[]{BeanBoxUtils.checkAOP(aop), classNameRegex, methodNameRegex});
        return this;
    }

    public BeanBoxContext addContextAop(Object aop, Class<?> clazz, String methodNameRegex) {
        return this.addContextAop(aop, clazz.getName() + "*", methodNameRegex);
    }

    protected void internalUtilMethods____________() {
    }

    private BeanBox doCreateBeanBox(Class<?> clazz) {
        Method[] methods;
        Annotation[] annos;
        Map<String, Object> m;
        BeanBox box = new BeanBox();
        box.setBeanClass(clazz);
        box.setSingleton(true);
        if (!this.isAllowAnnotation()) {
            return box;
        }
        if (BeanBoxUtils.checkAnnoExist(clazz, PROTOTYPE.class)) {
            box.setSingleton(false);
        } else if (this.allowSpringJsrAnnotation && (m = BeanBoxUtils.getAnnoAsMap(clazz, "org.springframework.context.annotation.Scope")) != null) {
            for (Map.Entry<String, Object> entry : m.entrySet()) {
                if (!"value".equals(entry.getKey())) continue;
                if ("prototype".equalsIgnoreCase(String.valueOf(entry.getValue()))) {
                    box.setSingleton(false);
                    continue;
                }
                if ("singleton".equalsIgnoreCase(String.valueOf(entry.getValue()))) {
                    box.setSingleton(true);
                    continue;
                }
                BeanBoxException.throwEX("'prototype' or 'singleton' required in @Scope annotation");
            }
        }
        BeanBox v = this.getInjectBoxFromAnno(clazz);
        if (v != null) {
            BeanBoxUtils.copyBoxValues(v, box);
        }
        for (Annotation anno : annos = clazz.getAnnotations()) {
            if (!anno.annotationType().isAnnotationPresent(AOP.class)) continue;
            Map<String, Object> annoMap = BeanBoxUtils.changeAnnotationValuesToMap(anno);
            Object aop = annoMap.get("value");
            String methodNameRule = (String)annoMap.get("method");
            if (methodNameRule == null || methodNameRule.length() <= 0 || aop == null) continue;
            box.addBeanAop(aop, methodNameRule);
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        for (Constructor<?> constr : constructorArray) {
            v = this.getInjectBoxFromAnno(constr);
            if (v == null) continue;
            box.setBeanClass(clazz);
            BeanBox[] paramInjects = this.getParameterInjectAsBeanBoxArray(constr);
            box.setConstructor(constr);
            box.setConstructorParams(paramInjects);
            if (paramInjects.length != 1) continue;
            if (v.target != null && v.target != EMPTY.class) {
                paramInjects[0].setTarget(v.target);
            }
            if (v.pureValue) {
                paramInjects[0].setPureValue(true);
            }
            if (v.qualifierAnno == null) continue;
            paramInjects[0].setQualifierAnno(v.qualifierAnno);
            paramInjects[0].setQualifierValue(v.qualifierValue);
        }
        for (Field f : ReflectionUtils.getSelfAndSuperClassFields(clazz)) {
            BeanBox inject = this.getInjectBoxFromAnno(f);
            if (inject == null) continue;
            box.checkOrCreateFieldInjects();
            inject.setType(f.getType());
            ReflectionUtils.makeAccessible(f);
            box.getFieldInjects().put(f, inject);
        }
        for (Method m2 : methods = ReflectionUtils.getAllDeclaredMethods(clazz)) {
            Annotation[] mtdAnnos;
            if (m2.getAnnotation(POSTCONSTRUCT.class) != null || m2.getAnnotation(PostConstruct.class) != null) {
                if (m2.getParameterTypes().length > 0) {
                    BeanBoxException.throwEX("In jBeanBox, PostConstruct should have no parameter.");
                }
                ReflectionUtils.makeAccessible(m2);
                box.setPostConstruct(m2);
            }
            if (m2.getAnnotation(PREDESTROY.class) != null || m2.getAnnotation(PreDestroy.class) != null) {
                if (m2.getParameterTypes().length > 0) {
                    BeanBoxException.throwEX("In jBeanBox, PostConstruct should have no parameter.");
                }
                ReflectionUtils.makeAccessible(m2);
                box.setPreDestroy(m2);
            }
            for (Annotation anno : mtdAnnos = m2.getAnnotations()) {
                Map<String, Object> annoMap;
                Object aop;
                if (!anno.annotationType().isAnnotationPresent(AOP.class) || (aop = (annoMap = BeanBoxUtils.changeAnnotationValuesToMap(anno)).get("value")) == null) continue;
                box.addMethodAop(aop, m2);
            }
            v = this.getInjectBoxFromAnno(m2);
            if (v == null) continue;
            ReflectionUtils.makeAccessible(m2);
            BeanBox[] paramInjects = this.getParameterInjectAsBeanBoxArray(m2);
            box.checkOrCreateMethodInjects();
            box.getMethodInjects().put(m2, paramInjects);
            if (paramInjects.length != 1) continue;
            if (v.target != null && v.target != EMPTY.class) {
                paramInjects[0].setTarget(v.target);
            }
            if (v.pureValue) {
                paramInjects[0].setPureValue(true);
            }
            if (v.qualifierAnno == null) continue;
            paramInjects[0].setQualifierAnno(v.qualifierAnno);
            paramInjects[0].setQualifierValue(v.qualifierValue);
        }
        return box;
    }

    private void bindBasicTypes() {
        this.bind(Object.class, EMPTY.class);
        this.bind(String.class, EMPTY.class);
        this.bind(Integer.class, EMPTY.class);
        this.bind(Boolean.class, EMPTY.class);
        this.bind(Byte.class, EMPTY.class);
        this.bind(Long.class, EMPTY.class);
        this.bind(Short.class, EMPTY.class);
        this.bind(Float.class, EMPTY.class);
        this.bind(Double.class, EMPTY.class);
        this.bind(Character.class, EMPTY.class);
        this.bind(List.class, EMPTY.class);
        this.bind(Map.class, EMPTY.class);
        this.bind(Set.class, EMPTY.class);
        this.bind(Integer.TYPE, EMPTY.class);
        this.bind(Boolean.TYPE, EMPTY.class);
        this.bind(Byte.TYPE, EMPTY.class);
        this.bind(Long.TYPE, EMPTY.class);
        this.bind(Short.TYPE, EMPTY.class);
        this.bind(Float.TYPE, EMPTY.class);
        this.bind(Double.TYPE, EMPTY.class);
        this.bind(Character.TYPE, EMPTY.class);
    }

    private BeanBox getBeanBox(Class<?> clazz, Boolean singleton) {
        BeanBoxException.assureNotNull(clazz, "Target class can not be null");
        BeanBox box = this.beanBoxCache.get(clazz);
        if (box != null) {
            if (singleton == null) {
                return box;
            }
            if (singleton.booleanValue() && box.isSingleton()) {
                return box;
            }
            return box.newCopy().setSingleton(singleton);
        }
        if (BeanBox.class.isAssignableFrom(clazz)) {
            try {
                box = (BeanBox)clazz.newInstance();
                if (box.singleton == null) {
                    box.singleton = true;
                }
            }
            catch (Exception e) {
                BeanBoxException.throwEX(e);
            }
        } else {
            box = this.doCreateBeanBox(clazz);
        }
        if (box.beanClass != null && PrototypeBean.class.isAssignableFrom(box.beanClass)) {
            box.setSingleton(false);
        }
        this.beanBoxCache.put(clazz, box);
        return box;
    }

    private Object getBeanFromBox(BeanBox box, boolean required, Set<Object> history) {
        Object id;
        BeanBoxException.assureNotNull(box, "Fail to build instance for a null beanBox");
        Object bean = null;
        if (box.isSingleton() && (bean = this.singletonCache.get(box)) != null) {
            return bean;
        }
        if (box.isPureValue()) {
            return box.getTarget();
        }
        if (box.getTarget() != null) {
            if (EMPTY.class != box.getTarget()) {
                return this.getBean(box.getTarget(), box.required, history);
            }
            if (box.type != null) {
                BeanBox bx = this.searchComponent(box);
                if (bx == null && box.qualifierAnno != null) {
                    return BeanBoxContext.notfoundOrException(box.type, box.required, box);
                }
                if (bx != null) {
                    return this.getBean(bx, box.required, history);
                }
                return this.getBean(box.type, box.required, history);
            }
            return BeanBoxContext.notfoundOrException(box.getTarget(), box.required, box);
        }
        boolean aopFound = false;
        if (box.getAopRules() != null || box.getMethodAops() != null) {
            aopFound = true;
        } else if (this.getAopRules() != null && box.getBeanClass() != null) {
            for (Object[] objectArray : this.getAopRules()) {
                if (!NameMatchUtil.nameMatch((String)objectArray[1], box.getBeanClass().getName())) continue;
                aopFound = true;
                break;
            }
        }
        if (aopFound) {
            bean = AopUtils.createProxyBean(box.getBeanClass(), box, this);
        } else {
            bean = box.create();
            if (bean == null) {
                bean = box.create(this);
            }
            if (bean == null) {
                bean = box.create(this, history);
            }
        }
        if (bean == null) {
            if (box.getConstructor() != null) {
                if (box.getConstructorParams() != null && box.getConstructorParams().length > 0) {
                    Object[] initargs = this.param2RealObjects(box.getConstructorParams(), history);
                    try {
                        bean = box.getConstructor().newInstance(initargs);
                    }
                    catch (Exception exception) {
                        return BeanBoxException.throwEX(exception);
                    }
                } else {
                    try {
                        bean = box.getConstructor().newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        return BeanBoxException.throwEX(e);
                    }
                }
            } else if (box.getBeanClass() != null) {
                if (EMPTY.class == box.getBeanClass() || box.getBeanClass().isInterface()) {
                    return BeanBoxContext.notfoundOrException(box.getBeanClass(), required, box);
                }
                try {
                    bean = box.getBeanClass().newInstance();
                }
                catch (Exception e) {
                    return BeanBoxContext.notfoundOrException(box.getBeanClass(), required, box);
                }
            } else {
                return BeanBoxContext.notfoundOrException(null, box.required, box);
            }
        }
        if (box.isSingleton() && (id = box.getSingletonId()) != null) {
            this.singletonCache.put(box, bean);
        }
        box.config(bean);
        box.config(bean, this);
        box.config(bean, this, history);
        if (box.getPostConstruct() != null) {
            ReflectionUtils.invokeMethod(box.getPostConstruct(), bean);
        }
        if (box.getFieldInjects() != null) {
            for (Map.Entry entry : box.getFieldInjects().entrySet()) {
                Field f = (Field)entry.getKey();
                BeanBox b = (BeanBox)entry.getValue();
                Object fieldValue = this.getBeanFromBox(b, b.required, history);
                if (fieldValue == null || EMPTY.class == fieldValue) continue;
                if (fieldValue instanceof String) {
                    fieldValue = this.valueTranslator.translate((String)fieldValue, b.type);
                }
                ReflectionUtils.setField(f, bean, fieldValue);
            }
        }
        if (box.getMethodInjects() != null) {
            for (Map.Entry entry : box.getMethodInjects().entrySet()) {
                Method m = (Method)entry.getKey();
                BeanBox[] paramBoxs = (BeanBox[])entry.getValue();
                if (paramBoxs != null && paramBoxs.length > 0) {
                    Object[] methodParams = this.param2RealObjects(paramBoxs, history);
                    ReflectionUtils.invokeMethod(m, bean, methodParams);
                    continue;
                }
                ReflectionUtils.invokeMethod(m, bean);
            }
        }
        return bean;
    }

    private Object[] param2RealObjects(BeanBox[] boxes, Set<Object> history) {
        Object[] result = new Object[boxes.length];
        for (int i = 0; i < boxes.length; ++i) {
            result[i] = this.getBeanFromBox(boxes[i], boxes[i].required, history);
            if (!(result[i] instanceof String)) continue;
            result[i] = this.valueTranslator.translate((String)result[i], boxes[i].type);
        }
        return result;
    }

    private BeanBox searchComponent(BeanBox box) {
        if (box.type == null || this.componentCache.isEmpty()) {
            return null;
        }
        String key = box.type.getName() + ":" + box.qualifierAnno + ":" + box.qualifierValue;
        BeanBox result = this.componentSearchCache.get(key);
        if (result == NO_THIS_COMPONENT) {
            return null;
        }
        if (result != null) {
            return result;
        }
        if (box.qualifierAnno != null && box.qualifierAnno.getSimpleName().equalsIgnoreCase("named")) {
            result = (BeanBox)this.bindCache.get(box.getQualifierValue());
        }
        if (result == null) {
            for (Class<?> compClass : this.componentCache) {
                if (!box.type.isAssignableFrom(compClass)) continue;
                BeanBox compBox = this.getBeanBox(compClass);
                if (box.qualifierAnno != null && (box.qualifierAnno != compBox.qualifierAnno || box.qualifierValue != null && !box.qualifierValue.equals(compBox.qualifierValue))) continue;
                if (result != null) {
                    BeanBoxException.throwEX("2 components " + compClass.getName() + " and " + result.beanClass.getName() + " found for type: " + box.type);
                }
                result = compBox;
            }
        }
        if (result != null) {
            this.componentSearchCache.put(key, result);
            return result;
        }
        this.componentSearchCache.put(key, NO_THIS_COMPONENT);
        return null;
    }

    private BeanBox getInjectBoxFromAnno(Object target) {
        Annotation[] anno = BeanBoxUtils.getAnnotations(target);
        return this.getInjectBoxFromAnnos(anno);
    }

    private BeanBox getInjectBoxFromAnnos(Annotation[] anno) {
        Class<? extends Annotation> type;
        BeanBox box = null;
        for (Annotation a : anno) {
            type = a.annotationType();
            if (INJECT.class.equals(type)) {
                INJECT i = (INJECT)a;
                box = new BeanBox().setTarget(i.value()).setRequired(i.required()).setPureValue(i.pureValue());
                continue;
            }
            if (VALUE.class.equals(type)) {
                box = new BeanBox().setTarget(((VALUE)a).value()).setRequired(true).setPureValue(true);
                continue;
            }
            if (!this.allowSpringJsrAnnotation) continue;
            if (Inject.class.equals(type)) {
                box = new BeanBox().setTarget(EMPTY.class).setPureValue(false);
                continue;
            }
            if (Autowired.class.equals(type)) {
                box = new BeanBox().setTarget(EMPTY.class).setRequired(((Autowired)a).required());
                continue;
            }
            if (!Value.class.equals(type)) continue;
            box = new BeanBox().setTarget(((Value)a).value()).setRequired(true).setPureValue(true);
        }
        for (Annotation a : anno) {
            type = a.annotationType();
            if (!BeanBoxUtils.ifSameOrChildAnno(type, NAMED.class, QUALIFILER.class) && (!this.allowSpringJsrAnnotation || !BeanBoxUtils.ifSameOrChildAnno(type, Named.class, Qualifier.class, org.springframework.beans.factory.annotation.Qualifier.class))) continue;
            Map<String, Object> v = BeanBoxUtils.changeAnnotationValuesToMap(a);
            if (v.size() > 1) {
                BeanBoxException.throwEX("jBeanBox does not support multiple property in Qualifier annotation: " + type);
            }
            if (box == null) {
                box = new BeanBox();
            }
            box.setQualifierAnno(type).setQualifierValue(v.isEmpty() ? null : v.values().iterator().next());
        }
        return box;
    }

    private BeanBox[] getParameterInjectAsBeanBoxArray(Object o) {
        Annotation[][] annoss = null;
        Class<?>[] paramTypes = null;
        if (o instanceof Method) {
            annoss = ((Method)o).getParameterAnnotations();
            paramTypes = ((Method)o).getParameterTypes();
        } else if (o instanceof Constructor) {
            annoss = ((Constructor)o).getParameterAnnotations();
            paramTypes = ((Constructor)o).getParameterTypes();
        } else {
            return (BeanBox[])BeanBoxException.throwEX("Only method or Constructor are allowed for:" + o);
        }
        BeanBox[] beanBoxes = new BeanBox[annoss.length];
        for (int i = 0; i < annoss.length; ++i) {
            Annotation[] annos = annoss[i];
            BeanBox v = this.getInjectBoxFromAnnos(annos);
            BeanBox inject = new BeanBox();
            if (v != null) {
                BeanBoxUtils.copyBoxValues(v, inject);
                if (inject.target == null) {
                    inject.target = EMPTY.class;
                }
            } else {
                inject.setTarget(EMPTY.class);
            }
            inject.setType(paramTypes[i]);
            beanBoxes[i] = inject;
        }
        return beanBoxes;
    }

    private static Object notfoundOrException(Object target, boolean required, BeanBox box) {
        if (required) {
            return BeanBoxException.throwEX("Can not create instance for: " + target + (box == null ? "" : box.getDebugInfo()));
        }
        return EMPTY.class;
    }

    protected void getterAndSetters____________() {
    }

    public boolean isAllowAnnotation() {
        return this.allowAnnotation;
    }

    public BeanBoxContext setAllowAnnotation(boolean allowAnnotation) {
        this.allowAnnotation = allowAnnotation;
        return this;
    }

    public boolean isAllowSpringJsrAnnotation() {
        return this.allowSpringJsrAnnotation;
    }

    public BeanBoxContext setAllowSpringJsrAnnotation(boolean allowSpringJsrAnnotation) {
        this.allowSpringJsrAnnotation = allowSpringJsrAnnotation;
        return this;
    }

    public ValueTranslator getValueTranslator() {
        return this.valueTranslator;
    }

    public BeanBoxContext setValueTranslator(ValueTranslator valueTranslator) {
        this.valueTranslator = valueTranslator;
        return this;
    }

    public Map<Object, Object> getBindCache() {
        return this.bindCache;
    }

    public BeanBoxContext setBindCache(Map<Object, Object> bindCache) {
        this.bindCache = bindCache;
        return this;
    }

    public Map<Object, Object> getSingletonCache() {
        return this.singletonCache;
    }

    public BeanBoxContext setSingletonCache(Map<Object, Object> singletonCache) {
        this.singletonCache = singletonCache;
        return this;
    }

    public List<Object[]> getAopRules() {
        return this.aopRules;
    }

    public BeanBoxContext setAopRules(List<Object[]> aopRules) {
        this.aopRules = aopRules;
        return this;
    }
}

