/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro;

import com.github.drinkjava2.jdbpro.DbPro;
import com.github.drinkjava2.jdbpro.DbProException;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.SqlHandler;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdbpro.template.SqlTemplateEngine;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.ResultSetHandler;

public class PreparedSQL {
    private StringBuilder sqlBuilder = new StringBuilder();
    private SqlOption operationType;
    private SqlOption masterSlaveOption;
    private DbPro switchTo;
    private Connection connection;
    private String sql;
    private Object[] params;
    private Boolean useTemplate = null;
    private SqlTemplateEngine templateEngine;
    private Map<String, Object> templateParamMap;
    private List<SqlHandler> sqlHandlers;
    private ResultSetHandler<?> resultSetHandler;
    private List<Class<?>> disabledHandlers;
    private List<SqlItem> others = null;
    private Boolean ignoreNull = null;
    private Boolean ignoreEmpty = null;
    private Object[] models;
    private String[] aliases;
    private List<String[]> givesList = null;
    private Object entityNet = null;

    public PreparedSQL() {
    }

    public PreparedSQL(SqlOption type, Connection conn, ResultSetHandler<?> rsh, String sql, Object ... params) {
        this.operationType = type;
        this.connection = conn;
        this.resultSetHandler = rsh;
        this.sql = sql;
        this.params = params;
    }

    public String getDebugInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\ntype=").append((Object)this.operationType);
        sb.append("\nsql=").append(this.sql);
        sb.append("\nparams=").append(Arrays.deepToString(this.params));
        sb.append("\nmasterSlaveSelect=").append((Object)this.masterSlaveOption);
        sb.append("\nconnection=").append(this.connection);
        sb.append("\nresultSetHandler=").append(this.resultSetHandler);
        sb.append("\nsqlHandlers=").append(this.sqlHandlers);
        sb.append("\nuseTemplate=").append(this.useTemplate);
        sb.append("\ntemplateEngine=").append(this.templateEngine);
        sb.append("\ntemplateParams=").append(this.templateParamMap);
        sb.append("\ndisabledHandlers=").append(this.disabledHandlers);
        sb.append("\nmasterSlaveOption=").append((Object)this.masterSlaveOption);
        sb.append("\n");
        return sb.toString();
    }

    public StringBuilder addSql(Object sqlPiece) {
        this.sqlBuilder.append(sqlPiece);
        return this.sqlBuilder;
    }

    public void addParam(Object param) {
        if (this.params == null) {
            this.params = new Object[1];
        } else {
            Object[] newParams = new Object[this.params.length + 1];
            System.arraycopy(this.params, 0, newParams, 0, this.params.length);
            this.params = newParams;
        }
        this.params[this.params.length - 1] = param;
    }

    public void addModel(Object model) {
        if (this.models == null) {
            this.models = new Object[1];
            this.aliases = new String[1];
        } else {
            Object[] newModels = new Object[this.models.length + 1];
            System.arraycopy(this.models, 0, newModels, 0, this.models.length);
            this.models = newModels;
            String[] newAliases = new String[this.aliases.length + 1];
            System.arraycopy(this.aliases, 0, newAliases, 0, this.aliases.length);
            this.aliases = newAliases;
        }
        this.models[this.models.length - 1] = model;
    }

    public void setLastAliases(String ... alias) {
        for (int i = 0; i < alias.length; ++i) {
            this.aliases[this.models.length - alias.length + i] = alias[i];
        }
    }

    public void addGives(String[] gives) {
        if (this.givesList == null) {
            this.givesList = new ArrayList<String[]>();
        }
        if (gives == null || gives.length < 2) {
            throw new DbProException("addGives at least need 2 alias parameters");
        }
        this.givesList.add(gives);
    }

    public void giveBoth(String alias1, String alias2) {
        if (this.givesList == null) {
            this.givesList = new ArrayList<String[]>();
        }
        this.givesList.add(new String[]{alias1, alias2});
        this.givesList.add(new String[]{alias2, alias1});
    }

    public void addTemplateMap(Map<String, Object> map) {
        if (map == null) {
            return;
        }
        if (this.templateParamMap == null) {
            this.templateParamMap = new HashMap<String, Object>();
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.templateParamMap.put(entry.getKey(), entry.getValue());
        }
    }

    public void addTemplateParam(SqlItem sp) {
        if (sp.getParameters() == null || sp.getParameters().length % 2 != 0) {
            throw new DbProException("Put type template parameter should be key1, value1, key2,value2... format");
        }
        if (this.templateParamMap == null) {
            this.templateParamMap = new HashMap<String, Object>();
        }
        for (int i = 1; i <= sp.getParameters().length / 2; ++i) {
            this.templateParamMap.put((String)sp.getParameters()[(i - 1) * 2], sp.getParameters()[(i - 1) * 2 + 1]);
        }
    }

    public void addSqlHandler(SqlHandler sqlHandler) {
        if (this.sqlHandlers == null) {
            this.sqlHandlers = new ArrayList<SqlHandler>();
        }
        for (int i = this.sqlHandlers.size() - 1; i >= 0; --i) {
            if (this.sqlHandlers.get(i).getOrder() > sqlHandler.getOrder()) continue;
            this.sqlHandlers.add(i + 1, sqlHandler);
            return;
        }
        this.sqlHandlers.add(sqlHandler);
    }

    public void disableHandlers(Object[] handlersClass) {
        if (handlersClass == null || handlersClass.length == 0) {
            throw new DbProException("disableHandlers method need at least 1 parameter");
        }
        if (this.disabledHandlers == null) {
            this.disabledHandlers = new ArrayList();
        }
        for (Object obj : handlersClass) {
            this.disabledHandlers.add((Class)obj);
        }
    }

    public boolean isDisabledHandler(Object handler) {
        if (this.disabledHandlers == null || this.disabledHandlers.isEmpty()) {
            return false;
        }
        for (Class<?> disabled : this.disabledHandlers) {
            if (!disabled.equals(handler.getClass())) continue;
            return true;
        }
        return false;
    }

    public void enableAllHandlers() {
        this.disabledHandlers = null;
    }

    public int getParamSize() {
        if (this.params == null) {
            return 0;
        }
        return this.params.length;
    }

    public void setResultSetHandler(ResultSetHandler<?> rsh) {
        if (this.resultSetHandler != null) {
            throw new DbProException("ResultSetHandler already exist and can only set 1, need use changeResultSetHandler method.");
        }
        this.resultSetHandler = rsh;
    }

    public void changeResultSetHandler(ResultSetHandler<?> rsh) {
        this.resultSetHandler = rsh;
    }

    public void addHandler(ResultSetHandler handler) {
        this.setResultSetHandler(handler);
    }

    public void addHandler(SqlHandler handler) {
        this.addSqlHandler(handler);
    }

    public void addNoParamHandlerByClass(Class handlerClass) {
        block5: {
            if (handlerClass == null) {
                throw new DbProException("HandlerClass can not be null");
            }
            try {
                if (ResultSetHandler.class.isAssignableFrom(handlerClass)) {
                    this.setResultSetHandler((ResultSetHandler)handlerClass.newInstance());
                    break block5;
                }
                if (SqlHandler.class.isAssignableFrom(handlerClass)) {
                    this.addSqlHandler((SqlHandler)handlerClass.newInstance());
                    break block5;
                }
                throw new DbProException("ResultSetHandler class or SqlHandler class required");
            }
            catch (Exception e) {
                throw new DbProException(e);
            }
        }
    }

    public Object[] getParams() {
        if (this.params == null) {
            return new Object[0];
        }
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGlobalAndThreadedHandlers(ImprovedQueryRunner dbPro) {
        if (dbPro.getSqlHandlers() != null) {
            for (SqlHandler handler : dbPro.getSqlHandlers()) {
                this.addSqlHandler(handler);
            }
        }
        if (ImprovedQueryRunner.getThreadLocalSqlHandlers() != null) {
            try {
                for (SqlHandler handler : ImprovedQueryRunner.getThreadLocalSqlHandlers()) {
                    this.addSqlHandler(handler);
                }
            }
            finally {
                ImprovedQueryRunner.setThreadLocalSqlHandlers(null);
            }
        }
    }

    public void ifNullSetType(SqlOption type) {
        if (this.operationType == null) {
            this.operationType = type;
        }
    }

    public void ifNullSetUseTemplate(Boolean useTemplate) {
        if (this.useTemplate == null) {
            this.useTemplate = useTemplate;
        }
    }

    public void addOther(SqlItem obj) {
        if (this.others == null) {
            this.others = new ArrayList<SqlItem>();
        }
        this.others.add(obj);
    }

    public void addSqlOrParam(boolean inlineStyle, String item) {
        if (inlineStyle) {
            this.addSql(item);
        } else if (this.getSqlBuilder().length() > 0) {
            this.addParam(item);
        } else {
            this.addSql(item);
        }
    }

    protected void GetterSetters_________________________() {
    }

    public SqlOption getOperationType() {
        return this.operationType;
    }

    public void setOperationType(SqlOption operationType) {
        this.operationType = operationType;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public Boolean getUseTemplate() {
        return this.useTemplate;
    }

    public void setUseTemplate(Boolean useTemplate) {
        this.useTemplate = useTemplate;
    }

    public SqlTemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(SqlTemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public Map<String, Object> getTemplateParamMap() {
        if (this.templateParamMap == null) {
            return new HashMap<String, Object>();
        }
        return this.templateParamMap;
    }

    public void setTemplateParamMap(Map<String, Object> templateParamMap) {
        this.templateParamMap = templateParamMap;
    }

    public List<SqlHandler> getSqlHandlers() {
        return this.sqlHandlers;
    }

    public void setSqlHandlers(List<SqlHandler> sqlHandlers) {
        this.sqlHandlers = sqlHandlers;
    }

    public ResultSetHandler<?> getResultSetHandler() {
        return this.resultSetHandler;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public void setMasterSlaveOption(SqlOption masterSlaveOption) {
        this.masterSlaveOption = masterSlaveOption;
    }

    public DbPro getSwitchTo() {
        return this.switchTo;
    }

    public void setSwitchTo(DbPro switchTo) {
        this.switchTo = switchTo;
    }

    public SqlOption getMasterSlaveOption() {
        return this.masterSlaveOption;
    }

    public List<Class<?>> getDisabledHandlers() {
        return this.disabledHandlers;
    }

    public void setDisabledHandlers(List<Class<?>> disabledHandlers) {
        this.disabledHandlers = disabledHandlers;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public Object[] getModels() {
        return this.models;
    }

    public void setModels(Object[] models) {
        this.models = models;
    }

    public List<String[]> getGivesList() {
        return this.givesList;
    }

    public void setGivesList(List<String[]> givesList) {
        this.givesList = givesList;
    }

    public Object getEntityNet() {
        return this.entityNet;
    }

    public void setEntityNet(Object entityNet) {
        this.entityNet = entityNet;
    }

    public List<SqlItem> getOthers() {
        return this.others;
    }

    public void setOthers(List<SqlItem> others) {
        this.others = others;
    }

    public StringBuilder getSqlBuilder() {
        return this.sqlBuilder;
    }

    public void setSqlBuilder(StringBuilder sqlBuilder) {
        this.sqlBuilder = sqlBuilder;
    }

    public Boolean getIgnoreNull() {
        return this.ignoreNull;
    }

    public void setIgnoreNull(Boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
    }

    public Boolean getIgnoreEmpty() {
        return this.ignoreEmpty;
    }

    public void setIgnoreEmpty(Boolean ignoreEmpty) {
        this.ignoreEmpty = ignoreEmpty;
    }
}

