/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro;

import com.github.drinkjava2.jdbpro.TextUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Text {
    private static final Map<Class<?>, String> textCache = new ConcurrentHashMap();

    public String toString() {
        return Text.classToString(this.getClass());
    }

    public static String classToString(Class<?> clazz) {
        if (textCache.containsKey(clazz)) {
            return textCache.get(clazz);
        }
        String thisPublicStaticClassName = clazz.getSimpleName();
        String javaSourceCode = TextUtils.getJavaSourceCode(clazz, "UTF-8");
        String classText = TextUtils.substringBetween(javaSourceCode, "public static class " + thisPublicStaticClassName, "*/");
        if (TextUtils.isEmpty(classText)) {
            throw new RuntimeException("Can not find text between \"public static class " + thisPublicStaticClassName + " and end tag \"*/\"");
        }
        String s = TextUtils.substringAfter(classText, "/*-");
        textCache.put(clazz, s);
        return s;
    }
}

