/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdbpro.handler;

import com.github.drinkjava2.jdbpro.DefaultOrderSqlHandler;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import java.util.Arrays;

public class PrintSqlHandler
extends DefaultOrderSqlHandler {
    private static boolean allowPrint = false;

    public static boolean isAllowPrint() {
        return allowPrint;
    }

    public static void setAllowPrint(boolean allowPrint) {
        PrintSqlHandler.allowPrint = allowPrint;
    }

    @Override
    public Object handle(ImprovedQueryRunner runner, PreparedSQL ps) {
        StackTraceElement[] steArray;
        StringBuffer sb = new StringBuffer();
        sb.append("======PrintSqlHandler=========\n");
        sb.append("| SQL:       " + ps.getSql()).append("\n");
        sb.append("| Param:     " + Arrays.deepToString(ps.getParams())).append("\n");
        long start = System.currentTimeMillis();
        Object obj = runner.runPreparedSQL(ps);
        long end = System.currentTimeMillis();
        for (StackTraceElement st : steArray = Thread.currentThread().getStackTrace()) {
            if (st.getClassName().contains("lang.Thread") || st.getClassName().contains(".drinkjava2.jdbpro") || st.getClassName().contains(".drinkjava2.jsqlbox")) continue;
            sb.append("| Location:  " + st.getClassName() + "." + st.getMethodName() + "(" + st.getFileName() + ":" + st.getLineNumber() + ")").append("\n");
            break;
        }
        sb.append("| Time use:  " + (end - start) + "ms\n");
        if (runner.getName() != null && runner.getName().length() > 0) {
            sb.append("| DB:        " + runner.getName()).append("\n");
        }
        sb.append("==============================");
        if (allowPrint) {
            System.out.println(sb.toString());
        }
        return obj;
    }
}

