/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdbpro.NormalJdbcTool;
import com.github.drinkjava2.jdialects.DDLCreateUtils;
import com.github.drinkjava2.jdialects.DDLDropUtils;
import com.github.drinkjava2.jdialects.DDLFeatures;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.DialectFunctionTemplate;
import com.github.drinkjava2.jdialects.DialectFunctionTranslator;
import com.github.drinkjava2.jdialects.DialectPaginationTemplate;
import com.github.drinkjava2.jdialects.DialectType;
import com.github.drinkjava2.jdialects.DialectTypeMappingTemplate;
import com.github.drinkjava2.jdialects.GuessDialectUtils;
import com.github.drinkjava2.jdialects.ReservedDBWords;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.id.IdGenerator;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jlogs.Log;
import com.github.drinkjava2.jlogs.LogFactory;
import java.sql.Connection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;

public class Dialect {
    @Deprecated
    public static final Dialect DerbyDialect = new Dialect("DerbyDialect");
    @Deprecated
    public static final Dialect OracleDialect = new Dialect("OracleDialect");
    @Deprecated
    public static final Dialect Oracle9Dialect = new Dialect("Oracle9Dialect");
    public static final Dialect DamengDialect = new Dialect("DamengDialect");
    public static final Dialect GBaseDialect = new Dialect("GBaseDialect");
    public static final Dialect AccessDialect = new Dialect("AccessDialect");
    public static final Dialect CobolDialect = new Dialect("CobolDialect");
    public static final Dialect DbfDialect = new Dialect("DbfDialect");
    public static final Dialect ExcelDialect = new Dialect("ExcelDialect");
    public static final Dialect ParadoxDialect = new Dialect("ParadoxDialect");
    public static final Dialect SQLiteDialect = new Dialect("SQLiteDialect");
    public static final Dialect TextDialect = new Dialect("TextDialect");
    public static final Dialect XMLDialect = new Dialect("XMLDialect");
    public static final Dialect Cache71Dialect = new Dialect("Cache71Dialect");
    public static final Dialect CUBRIDDialect = new Dialect("CUBRIDDialect");
    public static final Dialect DataDirectOracle9Dialect = new Dialect("DataDirectOracle9Dialect");
    public static final Dialect DB2390Dialect = new Dialect("DB2390Dialect");
    public static final Dialect DB2390V8Dialect = new Dialect("DB2390V8Dialect");
    public static final Dialect DB2400Dialect = new Dialect("DB2400Dialect");
    public static final Dialect DB297Dialect = new Dialect("DB297Dialect");
    public static final Dialect DB2Dialect = new Dialect("DB2Dialect");
    public static final Dialect DerbyTenFiveDialect = new Dialect("DerbyTenFiveDialect");
    public static final Dialect DerbyTenSevenDialect = new Dialect("DerbyTenSevenDialect");
    public static final Dialect DerbyTenSixDialect = new Dialect("DerbyTenSixDialect");
    public static final Dialect FirebirdDialect = new Dialect("FirebirdDialect");
    public static final Dialect FrontBaseDialect = new Dialect("FrontBaseDialect");
    public static final Dialect H2Dialect = new Dialect("H2Dialect");
    public static final Dialect HANAColumnStoreDialect = new Dialect("HANAColumnStoreDialect");
    public static final Dialect HANARowStoreDialect = new Dialect("HANARowStoreDialect");
    public static final Dialect HSQLDialect = new Dialect("HSQLDialect");
    public static final Dialect Informix10Dialect = new Dialect("Informix10Dialect");
    public static final Dialect InformixDialect = new Dialect("InformixDialect");
    public static final Dialect Ingres10Dialect = new Dialect("Ingres10Dialect");
    public static final Dialect Ingres9Dialect = new Dialect("Ingres9Dialect");
    public static final Dialect IngresDialect = new Dialect("IngresDialect");
    public static final Dialect InterbaseDialect = new Dialect("InterbaseDialect");
    public static final Dialect JDataStoreDialect = new Dialect("JDataStoreDialect");
    public static final Dialect MariaDB102Dialect = new Dialect("MariaDB102Dialect");
    public static final Dialect MariaDB103Dialect = new Dialect("MariaDB103Dialect");
    public static final Dialect MariaDB10Dialect = new Dialect("MariaDB10Dialect");
    public static final Dialect MariaDB53Dialect = new Dialect("MariaDB53Dialect");
    public static final Dialect MariaDBDialect = new Dialect("MariaDBDialect");
    public static final Dialect MckoiDialect = new Dialect("MckoiDialect");
    public static final Dialect MimerSQLDialect = new Dialect("MimerSQLDialect");
    public static final Dialect MySQL55Dialect = new Dialect("MySQL55Dialect");
    public static final Dialect MySQL57Dialect = new Dialect("MySQL57Dialect");
    public static final Dialect MySQL57InnoDBDialect = new Dialect("MySQL57InnoDBDialect");
    public static final Dialect MySQL5Dialect = new Dialect("MySQL5Dialect");
    public static final Dialect MySQL5InnoDBDialect = new Dialect("MySQL5InnoDBDialect");
    public static final Dialect MySQL8Dialect = new Dialect("MySQL8Dialect");
    public static final Dialect MySQLDialect = new Dialect("MySQLDialect");
    public static final Dialect MySQLInnoDBDialect = new Dialect("MySQLInnoDBDialect");
    public static final Dialect MySQLMyISAMDialect = new Dialect("MySQLMyISAMDialect");
    public static final Dialect Oracle10gDialect = new Dialect("Oracle10gDialect");
    public static final Dialect Oracle12cDialect = new Dialect("Oracle12cDialect");
    public static final Dialect Oracle8iDialect = new Dialect("Oracle8iDialect");
    public static final Dialect Oracle9iDialect = new Dialect("Oracle9iDialect");
    public static final Dialect PointbaseDialect = new Dialect("PointbaseDialect");
    public static final Dialect PostgresPlusDialect = new Dialect("PostgresPlusDialect");
    public static final Dialect PostgreSQL81Dialect = new Dialect("PostgreSQL81Dialect");
    public static final Dialect PostgreSQL82Dialect = new Dialect("PostgreSQL82Dialect");
    public static final Dialect PostgreSQL91Dialect = new Dialect("PostgreSQL91Dialect");
    public static final Dialect PostgreSQL92Dialect = new Dialect("PostgreSQL92Dialect");
    public static final Dialect PostgreSQL93Dialect = new Dialect("PostgreSQL93Dialect");
    public static final Dialect PostgreSQL94Dialect = new Dialect("PostgreSQL94Dialect");
    public static final Dialect PostgreSQL95Dialect = new Dialect("PostgreSQL95Dialect");
    public static final Dialect PostgreSQL9Dialect = new Dialect("PostgreSQL9Dialect");
    public static final Dialect PostgreSQLDialect = new Dialect("PostgreSQLDialect");
    public static final Dialect ProgressDialect = new Dialect("ProgressDialect");
    public static final Dialect RDMSOS2200Dialect = new Dialect("RDMSOS2200Dialect");
    public static final Dialect SAPDBDialect = new Dialect("SAPDBDialect");
    public static final Dialect SQLServer2005Dialect = new Dialect("SQLServer2005Dialect");
    public static final Dialect SQLServer2008Dialect = new Dialect("SQLServer2008Dialect");
    public static final Dialect SQLServer2012Dialect = new Dialect("SQLServer2012Dialect");
    public static final Dialect SQLServerDialect = new Dialect("SQLServerDialect");
    public static final Dialect Sybase11Dialect = new Dialect("Sybase11Dialect");
    public static final Dialect SybaseAnywhereDialect = new Dialect("SybaseAnywhereDialect");
    public static final Dialect SybaseASE157Dialect = new Dialect("SybaseASE157Dialect");
    public static final Dialect SybaseASE15Dialect = new Dialect("SybaseASE15Dialect");
    public static final Dialect SybaseDialect = new Dialect("SybaseDialect");
    public static final Dialect Teradata14Dialect = new Dialect("Teradata14Dialect");
    public static final Dialect TeradataDialect = new Dialect("TeradataDialect");
    public static final Dialect TimesTenDialect = new Dialect("TimesTenDialect");
    private static Boolean globalAllowReservedWords = false;
    private static final Log logger = LogFactory.getLog(Dialect.class);
    private static Boolean globalAllowShowSql = false;
    private static String globalSqlFunctionPrefix = null;
    private static Boolean globalEnableTopLimitPagin = true;
    public static final String NOT_SUPPORT = "NOT_SUPPORT";
    private static final String SKIP_ROWS = "$SKIP_ROWS";
    private static final String PAGESIZE = "$PAGESIZE";
    private static final String TOTAL_ROWS = "$TOTAL_ROWS";
    private static final String DISTINCT_TAG = "($DISTINCT)";
    public String sqlTemplate;
    public String topLimitTemplate;
    public String name;
    public DialectType type;
    public Map<Type, String> typeMappings = new EnumMap<Type, String>(Type.class);
    public Map<String, String> functions = new HashMap<String, String>();
    public DDLFeatures ddlFeatures = new DDLFeatures();
    public static Dialect[] dialects;

    public Dialect(String name) {
        this.name = name;
        try {
            this.type = DialectType.valueOf(name);
        }
        catch (Exception e) {
            this.type = DialectType.Customized;
        }
        this.sqlTemplate = DialectPaginationTemplate.initializePaginSQLTemplate(this);
        this.topLimitTemplate = DialectPaginationTemplate.initializeTopLimitSqlTemplate(this);
        DDLFeatures.initDDLFeatures(this);
    }

    @Deprecated
    public static Dialect[] values() {
        return dialects;
    }

    public static Dialect guessDialect(Connection connection) {
        return GuessDialectUtils.guessDialect(connection);
    }

    public static Dialect guessDialect(DataSource datasource) {
        return GuessDialectUtils.guessDialect(datasource);
    }

    private void checkIfReservedWord(String word, String ... tableName) {
        if (ReservedDBWords.isReservedWord(word)) {
            String inTable = tableName.length > 0 ? "In table " + tableName[0] + ", " : "";
            String reservedForDB = ReservedDBWords.reservedForDB(word);
            if (ReservedDBWords.isReservedWord(this, word)) {
                if (globalAllowReservedWords.booleanValue()) {
                    logger.warn(inTable + "\"" + word + "\" is a reserved word of \"" + reservedForDB + "\", should not use it as table, column, unique or index name");
                } else {
                    DialectException.throwEX(inTable + "\"" + word + "\" is a reserved word of \"" + reservedForDB + "\", should not use it as table, column, unique or index name. if you really want use this reserved word, call Dialect.setGlobalAllowReservedWords() at application starting.");
                }
            } else {
                logger.warn(inTable + "\"" + word + "\" is a reserved word of other database \"" + reservedForDB + "\", not recommend be used as table, column, unique or index name");
            }
        }
    }

    public String checkReservedWords(String ... words) {
        if (words == null || words.length == 0) {
            return null;
        }
        for (String word : words) {
            this.checkIfReservedWord(word, new String[0]);
        }
        return words[0];
    }

    public String checkNotEmptyReservedWords(String word, String type, String tableName) {
        if (StrUtils.isEmpty(word)) {
            DialectException.throwEX(type + " can not be empty");
        }
        this.checkIfReservedWord(word, tableName);
        return word;
    }

    public String translateToDDLType(ColumnModel col) {
        Type type = col.getColumnType();
        String value = this.typeMappings.get((Object)type);
        if (StrUtils.isEmpty(value) || "N/A".equals(value) || "n/a".equals(value)) {
            DialectException.throwEX("Type \"" + (Object)((Object)type) + "\" is not supported by dialect \"" + this + "\"");
        }
        if (value.contains("|")) {
            String[] typeTempls;
            for (String templ : typeTempls = StrUtils.split("|", value)) {
                if (templ.contains("<")) {
                    String[] limitType = StrUtils.split("<", templ);
                    if (col.getLength() <= 0 || col.getLength() >= Integer.parseInt(limitType[1])) continue;
                    return this.replacePlaceHolders(type, limitType[0], col);
                }
                return this.replacePlaceHolders(type, templ, col);
            }
            return (String)DialectException.throwEX("Type \"" + (Object)((Object)type) + "\" is not supported by dialect \"" + this + "\" of template:" + value);
        }
        if (value.contains("$")) {
            return this.replacePlaceHolders(type, value, col);
        }
        return value;
    }

    private String replacePlaceHolders(Type type, String value, ColumnModel col) {
        String newValue = StrUtils.replace(value, "$l", String.valueOf(col.getLength()));
        if (newValue.contains("$p")) {
            newValue = StrUtils.replace(newValue, "$p", String.valueOf(col.getPrecision()));
        }
        if (newValue.contains("$s")) {
            newValue = StrUtils.replace(newValue, "$s", String.valueOf(col.getScale()));
        }
        return newValue;
    }

    private static String aTopLimitSqlExample(String template) {
        String result = StrUtils.replaceIgnoreCase(template, "$SQL", "select * from users order by userid");
        result = StrUtils.replaceIgnoreCase(result, "$BODY", "* from users order by userid");
        result = StrUtils.replaceIgnoreCase(result, " ($DISTINCT)", "");
        result = StrUtils.replaceIgnoreCase(result, SKIP_ROWS, "0");
        result = StrUtils.replaceIgnoreCase(result, PAGESIZE, "10");
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS, "10");
        return result;
    }

    public String paginAndTrans(int pageNumber, int pageSize, String ... sql) {
        return this.pagin(pageNumber, pageSize, this.trans(sql));
    }

    public String trans(String ... sql) {
        StringBuilder sb = new StringBuilder();
        for (String str : sql) {
            sb.append(str);
        }
        return DialectFunctionTranslator.instance.doTranslate(this, sb.toString());
    }

    public String pagin(int pageNumber, int pageSize, String sql) {
        String useTemplate;
        String result = null;
        DialectException.assureNotNull(sql, "sql string can not be null");
        String trimedSql = sql.trim();
        DialectException.assureNotEmpty(trimedSql, "sql string can not be empty");
        if (!StrUtils.startsWithIgnoreCase(trimedSql, "select ")) {
            return (String)DialectException.throwEX("SQL should start with \"select \".");
        }
        String body = trimedSql.substring(7).trim();
        DialectException.assureNotEmpty(body, "SQL body can not be empty");
        int skipRows = (pageNumber - 1) * pageSize;
        int skipRowsPlus1 = skipRows + 1;
        int totalRows = pageNumber * pageSize;
        int totalRowsPlus1 = totalRows + 1;
        if (globalEnableTopLimitPagin.booleanValue() && skipRows == 0) {
            useTemplate = this.topLimitTemplate;
            if (SQLServer2012Dialect.equals(this) && !StrUtils.containsIgnoreCase(trimedSql, "order by ")) {
                useTemplate = Dialect.SQLServer2005Dialect.topLimitTemplate;
            }
        } else {
            useTemplate = this.sqlTemplate;
            if (SQLServer2012Dialect.equals(this) && !StrUtils.containsIgnoreCase(trimedSql, "order by ")) {
                useTemplate = Dialect.SQLServer2005Dialect.sqlTemplate;
            }
        }
        if (NOT_SUPPORT.equals(useTemplate)) {
            if (!NOT_SUPPORT.equals(this.topLimitTemplate)) {
                return (String)DialectException.throwEX("Dialect \"" + this + "\" only support top limit SQL, for example: \"" + Dialect.aTopLimitSqlExample(this.topLimitTemplate) + "\"");
            }
            return (String)DialectException.throwEX("Dialect \"" + this + "\" does not support physical pagination");
        }
        if (useTemplate.contains(DISTINCT_TAG)) {
            if (!StrUtils.startsWithIgnoreCase(body, "distinct ")) {
                useTemplate = StrUtils.replace(useTemplate, DISTINCT_TAG, "");
            } else {
                useTemplate = StrUtils.replace(useTemplate, DISTINCT_TAG, "distinct");
                body = body.substring(9);
            }
        }
        result = StrUtils.replaceIgnoreCase(useTemplate, SKIP_ROWS, String.valueOf(skipRows));
        result = StrUtils.replaceIgnoreCase(result, PAGESIZE, String.valueOf(pageSize));
        result = StrUtils.replaceIgnoreCase(result, TOTAL_ROWS, String.valueOf(totalRows));
        result = StrUtils.replace(result, "$SQL", trimedSql);
        result = StrUtils.replace(result, "$BODY", body);
        if (Dialect.getGlobalAllowShowSql().booleanValue()) {
            logger.info("Paginated sql: " + result);
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        return this.name.equals(((Dialect)obj).name);
    }

    public boolean isMySqlFamily() {
        return this.toString().startsWith("MySQL");
    }

    public boolean isInfomixFamily() {
        return this.toString().startsWith("Infomix");
    }

    public boolean isOracleFamily() {
        return this.toString().startsWith("Oracle");
    }

    public boolean isSQLServerFamily() {
        return this.toString().startsWith("SQLServer");
    }

    public boolean isH2Family() {
        return H2Dialect.equals(this);
    }

    public boolean isPostgresFamily() {
        return this.toString().startsWith("Postgres");
    }

    public boolean isSybaseFamily() {
        return this.toString().startsWith("Sybase");
    }

    public boolean isDB2Family() {
        return this.toString().startsWith("DB2");
    }

    public boolean isDerbyFamily() {
        return this.toString().startsWith("Derby");
    }

    public String[] toCreateDDL(Class<?> ... entityClasses) {
        return DDLCreateUtils.toCreateDDL(this, TableModelUtils.entity2ReadOnlyModels(entityClasses));
    }

    public String[] toDropDDL(Class<?> ... entityClasses) {
        return DDLDropUtils.toDropDDL(this, TableModelUtils.entity2ReadOnlyModels(entityClasses));
    }

    public String[] toDropAndCreateDDL(Class<?> ... entityClasses) {
        return this.toDropAndCreateDDL(TableModelUtils.entity2ReadOnlyModels(entityClasses));
    }

    public String[] toCreateDDL(TableModel ... tables) {
        return DDLCreateUtils.toCreateDDL(this, tables);
    }

    public String[] toDropDDL(TableModel ... tables) {
        return DDLDropUtils.toDropDDL(this, tables);
    }

    public String[] toDropAndCreateDDL(TableModel ... tables) {
        String[] drop = DDLDropUtils.toDropDDL(this, tables);
        String[] create = DDLCreateUtils.toCreateDDL(this, tables);
        return StrUtils.joinStringArray(drop, create);
    }

    public String dropTableDDL(String tableName) {
        return this.ddlFeatures.dropTableString.replaceFirst("_TABLENAME", tableName);
    }

    public String dropSequenceDDL(String sequenceName) {
        if (DDLFeatures.isValidDDLTemplate(this.ddlFeatures.dropSequenceStrings)) {
            return StrUtils.replace(this.ddlFeatures.dropSequenceStrings, "_SEQNAME", sequenceName);
        }
        return (String)DialectException.throwEX("Dialect \"" + this + "\" does not support drop sequence ddl, on sequence \"" + sequenceName + "\"");
    }

    public String dropFKeyDDL(String tableName, String fkeyName) {
        if (DDLFeatures.isValidDDLTemplate(this.ddlFeatures.dropForeignKeyString)) {
            return "alter table " + tableName + " " + this.ddlFeatures.dropForeignKeyString + " " + fkeyName;
        }
        return (String)DialectException.throwEX("Dialect \"" + this + "\" does not support drop foreign key, on foreign key \"" + fkeyName + "\"");
    }

    public Object getNexID(IdGenerator idGenerator, NormalJdbcTool jdbc, Type dataType) {
        return idGenerator.getNextID(jdbc, this, dataType);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DDLFeatures getDdlFeatures() {
        return this.ddlFeatures;
    }

    public static Boolean getGlobalAllowReservedWords() {
        return globalAllowReservedWords;
    }

    public static void setGlobalAllowReservedWords(Boolean ifAllowReservedWords) {
        globalAllowReservedWords = ifAllowReservedWords;
    }

    public static Boolean getGlobalAllowShowSql() {
        return globalAllowShowSql;
    }

    public static void setGlobalAllowShowSql(Boolean ifAllowShowSql) {
        globalAllowShowSql = ifAllowShowSql;
    }

    public static String getGlobalSqlFunctionPrefix() {
        return globalSqlFunctionPrefix;
    }

    public static void setGlobalSqlFunctionPrefix(String sqlFunctionPrefix) {
        globalSqlFunctionPrefix = sqlFunctionPrefix;
    }

    public static Boolean getGlobalEnableTopLimitPagin() {
        return globalEnableTopLimitPagin;
    }

    public static void setGlobalEnableTopLimitPagin(Boolean globalEnableTopLimitPagin) {
        Dialect.globalEnableTopLimitPagin = globalEnableTopLimitPagin;
    }

    static {
        DialectTypeMappingTemplate.initTypeMappings();
        DialectFunctionTemplate.initFunctionTemplates();
        dialects = new Dialect[]{DerbyDialect, OracleDialect, Oracle9Dialect, DamengDialect, GBaseDialect, AccessDialect, CobolDialect, DbfDialect, ExcelDialect, ParadoxDialect, SQLiteDialect, TextDialect, XMLDialect, Cache71Dialect, CUBRIDDialect, DataDirectOracle9Dialect, DB2390Dialect, DB2390V8Dialect, DB2400Dialect, DB297Dialect, DB2Dialect, DerbyTenFiveDialect, DerbyTenSevenDialect, DerbyTenSixDialect, FirebirdDialect, FrontBaseDialect, H2Dialect, HANAColumnStoreDialect, HANARowStoreDialect, HSQLDialect, Informix10Dialect, InformixDialect, Ingres10Dialect, Ingres9Dialect, IngresDialect, InterbaseDialect, JDataStoreDialect, MariaDB102Dialect, MariaDB103Dialect, MariaDB10Dialect, MariaDB53Dialect, MariaDBDialect, MckoiDialect, MimerSQLDialect, MySQL55Dialect, MySQL57Dialect, MySQL57InnoDBDialect, MySQL5Dialect, MySQL5InnoDBDialect, MySQL8Dialect, MySQLDialect, MySQLInnoDBDialect, MySQLMyISAMDialect, Oracle10gDialect, Oracle12cDialect, Oracle8iDialect, Oracle9iDialect, PointbaseDialect, PostgresPlusDialect, PostgreSQL81Dialect, PostgreSQL82Dialect, PostgreSQL91Dialect, PostgreSQL92Dialect, PostgreSQL93Dialect, PostgreSQL94Dialect, PostgreSQL95Dialect, PostgreSQL9Dialect, PostgreSQLDialect, ProgressDialect, RDMSOS2200Dialect, SAPDBDialect, SQLServer2005Dialect, SQLServer2008Dialect, SQLServer2012Dialect, SQLServerDialect, Sybase11Dialect, SybaseAnywhereDialect, SybaseASE157Dialect, SybaseASE15Dialect, SybaseDialect, Teradata14Dialect, TeradataDialect, TimesTenDialect};
    }
}

