/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.TableModelUtilsOfDb;
import com.github.drinkjava2.jdialects.TableModelUtilsOfEntity;
import com.github.drinkjava2.jdialects.TableModelUtilsOfJavaSrc;
import com.github.drinkjava2.jdialects.model.TableModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import javax.sql.DataSource;

public abstract class TableModelUtils {
    public static final String OPT_LINK_STYLE = "linkStyle";
    public static final String OPT_FIELD_FLAGS = "fieldFlags";
    public static final String OPT_PACKAGE_NAME = "packageName";
    public static final String OPT_IMPORTS = "imports";
    public static final String OPT_REMOVE_DEFAULT_IMPORTS = "removeDefaultImports";
    public static final String OPT_CLASS_DEFINITION = "classDefinition";
    public static final String OPT_PUBLIC_FIELD = "enablePublicField";
    public static final String OPT_EXCLUDE_TABLES = "excludeTables";

    public static Class<?> tableNameToEntityClass(String tableName) {
        return TableModelUtilsOfEntity.tableNameToEntityClass(tableName);
    }

    public static TableModel entity2Model(Class<?> entityClass) {
        return TableModelUtilsOfEntity.entity2EditableModel(entityClass);
    }

    public static TableModel[] entity2Models(Class<?> ... entityClasses) {
        return TableModelUtilsOfEntity.entity2EditableModels(entityClasses);
    }

    public static TableModel entity2ReadOnlyModel(Class<?> entityClass) {
        return TableModelUtilsOfEntity.entity2ReadOnlyModel(entityClass);
    }

    public static TableModel[] entity2ReadOnlyModels(Class<?> ... entityClasses) {
        return TableModelUtilsOfEntity.entity2ReadOnlyModel(entityClasses);
    }

    public static TableModel[] db2Models(Connection con, Dialect dialect) {
        return TableModelUtilsOfDb.db2Models(con, dialect);
    }

    public static void db2JavaSrcFiles(DataSource ds, Dialect dialect, String outputfolder, Map<String, Object> setting) {
        block8: {
            Connection conn = null;
            try {
                HashSet<String> excludeTables;
                conn = ds.getConnection();
                TableModel[] models = TableModelUtils.db2Models(conn, dialect);
                File dir = new File(outputfolder);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                if ((excludeTables = (HashSet<String>)setting.get(OPT_EXCLUDE_TABLES)) != null) {
                    HashSet<String> t = new HashSet<String>();
                    for (String s : excludeTables) {
                        t.add(s.trim().toLowerCase());
                    }
                    excludeTables = t;
                }
                for (TableModel model : models) {
                    String tableName = model.getTableName();
                    if (excludeTables != null && excludeTables.contains(tableName.toLowerCase())) continue;
                    File writename = new File(dir, TableModelUtilsOfJavaSrc.getClassNameFromTableModel(model) + ".java");
                    writename.createNewFile();
                    BufferedWriter out = new BufferedWriter(new FileWriter(writename));
                    String javaSrc = TableModelUtils.model2JavaSrc(model, setting);
                    out.write(javaSrc);
                    out.flush();
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (conn == null) break block8;
                try {
                    conn.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static String model2JavaSrc(TableModel model, Map<String, Object> setting) {
        return TableModelUtilsOfJavaSrc.modelToJavaSourceCode(model, setting);
    }

    public static void bindGlobalModel(Class<?> entityClass, TableModel tableModel) {
        TableModelUtilsOfEntity.globalTableModelCache.put(entityClass, tableModel);
    }
}

