/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jdialects;

import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.StrUtils;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.TypeUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.FKeyModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jdialects.springsrc.utils.StringUtils;
import java.util.HashSet;
import java.util.Map;

public abstract class TableModelUtilsOfJavaSrc {
    private static String transColumnNameToFieldName(String colName) {
        if (StrUtils.isEmpty(colName)) {
            return colName;
        }
        String rawColName = StrUtils.clearQuote(colName);
        if (!colName.contains("_")) {
            if (rawColName.toUpperCase().equals(rawColName)) {
                return rawColName.toLowerCase();
            }
            return StrUtils.toLowerCaseFirstOne(rawColName);
        }
        StringBuilder sb = new StringBuilder();
        char[] chars = rawColName.toLowerCase().toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '_') continue;
            if (i > 0 && chars[i - 1] == '_' && sb.length() > 0) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getClassNameFromTableModel(TableModel model) {
        String className;
        DialectException.assureNotNull(model, "TableModel can not be null");
        if (model.getEntityClass() != null) {
            className = model.getEntityClass().getSimpleName();
        } else {
            DialectException.assureNotEmpty(model.getTableName(), "TableName can not be empty in TableModel");
            String tableName = TableModelUtilsOfJavaSrc.transColumnNameToFieldName(model.getTableName());
            if (tableName.toUpperCase().equals(tableName)) {
                tableName = tableName.toLowerCase();
            }
            className = StrUtils.toUpperCaseFirstOne(tableName);
        }
        DialectException.assureNotEmpty(className, "TableName can not be empty in TableModel");
        return className;
    }

    public static String modelToJavaSourceCode(TableModel model, Map<String, Object> setting) {
        StringBuilder body = new StringBuilder();
        TableModelUtilsOfJavaSrc.generatePackage(setting, body);
        TableModelUtilsOfJavaSrc.generateImports(setting, body);
        String className = TableModelUtilsOfJavaSrc.getClassNameFromTableModel(model);
        int fkeyCount = TableModelUtilsOfJavaSrc.generateAnnotationForClass(model, body, className);
        TableModelUtilsOfJavaSrc.generateClassBegin(setting, body, className);
        TableModelUtilsOfJavaSrc.generateStaticFields(model, setting, body, className);
        TableModelUtilsOfJavaSrc.generateFields(model, setting, fkeyCount, body);
        TableModelUtilsOfJavaSrc.generateGetterAndSetter(model, setting, className, body);
        TableModelUtilsOfJavaSrc.generateClassEnd(body);
        return body.toString();
    }

    private static void generateStaticFields(TableModel model, Map<String, Object> setting, StringBuilder body, String className) {
        boolean fieldFlags = Boolean.TRUE.equals(setting.get("fieldFlags"));
        StringBuilder fieldSB = new StringBuilder();
        HashSet<String> processed = new HashSet<String>();
        if (fieldFlags) {
            fieldSB.append("\tpublic static final String TABLE_NAME = \"").append(model.getTableName()).append("\";\n\n");
            for (ColumnModel col : model.getColumns()) {
                String columnName = col.getColumnName();
                if (processed.contains(columnName)) continue;
                String rawColName = StrUtils.clearQuote(columnName);
                processed.add(columnName);
                fieldSB.append("\tpublic static final String ").append(rawColName.toUpperCase()).append(" = \"").append(columnName).append("\";\n\n");
            }
        }
        body.append(fieldSB.toString()).append("\n\n");
    }

    private static void generateClassEnd(StringBuilder body) {
        body.append("}\n");
    }

    private static void generateClassBegin(Map<String, Object> setting, StringBuilder body, String className) {
        String classDefinition = (String)setting.get("classDefinition");
        body.append(StrUtils.replace(classDefinition, "$1", className)).append(" {\n\n");
    }

    private static int generateAnnotationForClass(TableModel model, StringBuilder body, String className) {
        if (!StringUtils.isEmpty(model.getComment())) {
            body.append("/**\n * ").append(model.getComment()).append("\n */\n");
        }
        if (!className.equals(model.getTableName())) {
            body.append("@Table").append("(name=\"").append(model.getTableName()).append("\")\n");
        }
        int fkeyCount = 0;
        for (FKeyModel fkey : model.getFkeyConstraints()) {
            if (fkey.getColumnNames().size() <= 1) continue;
            body.append("@FKey");
            if (fkeyCount > 0) {
                body.append(fkeyCount);
            }
            body.append("(");
            ++fkeyCount;
            if (!StrUtils.isEmpty(fkey.getFkeyName())) {
                body.append("name=\"").append(fkey.getFkeyName()).append("\", ");
            }
            if (!fkey.getDdl().booleanValue()) {
                body.append("ddl=false, ");
            }
            String fkeyCols = StrUtils.listToString(fkey.getColumnNames());
            fkeyCols = StrUtils.replace(fkeyCols, ",", "\",\"");
            String refCols = StrUtils.arrayToString(fkey.getRefTableAndColumns());
            refCols = StrUtils.replace(refCols, ",", "\",\"");
            body.append("columns={\"").append(fkeyCols).append("\"}, refs={\"").append(refCols).append("\"}");
            body.append(")\n");
        }
        return fkeyCount;
    }

    private static void generatePackage(Map<String, Object> setting, StringBuilder body) {
        String packageName = (String)setting.get("packageName");
        if (!StrUtils.isEmpty(packageName)) {
            body.append("package ").append(packageName).append(";\n");
        }
        body.append("\n");
    }

    private static void generateImports(Map<String, Object> setting, StringBuilder body) {
        String imports;
        Boolean removeDefaultImports = (Boolean)setting.get("removeDefaultImports");
        if (removeDefaultImports == null || !removeDefaultImports.booleanValue()) {
            body.append("import static com.github.drinkjava2.jsqlbox.JAVA8.*;\n");
            body.append("import static com.github.drinkjava2.jsqlbox.SQL.*;\n");
            body.append("import static com.github.drinkjava2.jsqlbox.DB.*;\n");
            body.append("import com.github.drinkjava2.jdbpro.SqlItem;\n");
            body.append("import com.github.drinkjava2.jdialects.annotation.jdia.*;\n");
            body.append("import com.github.drinkjava2.jdialects.annotation.jpa.*;\n");
            body.append("import com.github.drinkjava2.jsqlbox.*;\n");
        }
        if (!StrUtils.isEmpty(imports = (String)setting.get("imports"))) {
            body.append(imports);
        }
        body.append("\n");
    }

    private static void generateFields(TableModel model, Map<String, Object> setting, int fkeyCount, StringBuilder body) {
        boolean enablePublicField = Boolean.TRUE.equals(setting.get("enablePublicField"));
        StringBuilder pkeySB = new StringBuilder();
        StringBuilder normalSB = new StringBuilder();
        HashSet<String> processed = new HashSet<String>();
        for (ColumnModel col : model.getColumns()) {
            boolean lenNotEq255;
            String fieldName;
            StringBuilder sb;
            String columnName = col.getColumnName();
            if (processed.contains(columnName)) continue;
            processed.add(columnName);
            Class<?> javaType = TypeUtils.dialectTypeToJavaType(col.getColumnType());
            if (javaType == null) continue;
            StringBuilder stringBuilder = sb = col.getPkey() != false ? pkeySB : normalSB;
            if (!StringUtils.isEmpty(col.getComment())) {
                sb.append("\t/**\n\t * ").append(col.getComment()).append("\n\t */\n");
            }
            if (StrUtils.isEmpty(fieldName = col.getEntityField())) {
                fieldName = TableModelUtilsOfJavaSrc.transColumnNameToFieldName(columnName);
            }
            if (col.getPkey().booleanValue()) {
                sb.append("\t@Id\n");
            }
            boolean isStr = Type.VARCHAR.equals((Object)col.getColumnType()) || Type.CHAR.equals((Object)col.getColumnType());
            boolean bl = lenNotEq255 = 255 != col.getLength();
            if (!fieldName.equalsIgnoreCase(columnName) || isStr && lenNotEq255) {
                sb.append("\t@Column(");
                sb.append("name=\"").append(columnName).append("\", ");
                if (isStr && lenNotEq255) {
                    sb.append("length=").append(col.getLength()).append(", ");
                }
                sb.setLength(sb.length() - 2);
                sb.append(")\n");
            }
            for (FKeyModel fkey : model.getFkeyConstraints()) {
                if (fkey.getColumnNames().size() != 1 || !columnName.equalsIgnoreCase(fkey.getColumnNames().get(0))) continue;
                sb.append("\t@SingleFKey");
                sb.append("(");
                ++fkeyCount;
                if (!StrUtils.isEmpty(fkey.getFkeyName())) {
                    sb.append("name=\"").append(fkey.getFkeyName()).append("\", ");
                }
                if (!fkey.getDdl().booleanValue()) {
                    sb.append("ddl=false, ");
                }
                String refCols = StrUtils.arrayToString(fkey.getRefTableAndColumns());
                refCols = StrUtils.replace(refCols, ",", "\",\"");
                sb.append("refs={\"").append(refCols).append("\"}");
                sb.append(")\n");
            }
            String accessModifier = "private";
            if (enablePublicField) {
                accessModifier = "public";
            }
            sb.append("\t").append(accessModifier).append(' ').append(javaType.getSimpleName()).append(' ').append(fieldName).append(";\n\n");
        }
        body.append(pkeySB.toString()).append("\n\n").append(normalSB.toString()).append("\n\n");
    }

    private static void generateGetterAndSetter(TableModel model, Map<String, Object> setting, String className, StringBuilder body) {
        boolean linkStyle = Boolean.TRUE.equals(setting.get("linkStyle"));
        StringBuilder pkeySB = new StringBuilder();
        StringBuilder normalSB = new StringBuilder();
        HashSet<String> processed = new HashSet<String>();
        for (ColumnModel col : model.getColumns()) {
            if (processed.contains(col.getColumnName())) continue;
            processed.add(col.getColumnName());
            Class<?> javaType = TypeUtils.dialectTypeToJavaType(col.getColumnType());
            if (javaType == null) continue;
            StringBuilder sb = col.getPkey() != false ? pkeySB : normalSB;
            String fieldName = col.getEntityField();
            if (StrUtils.isEmpty(fieldName)) {
                fieldName = TableModelUtilsOfJavaSrc.transColumnNameToFieldName(col.getColumnName());
            }
            String getFieldName = "get" + StrUtils.toUpperCaseFirstOne(fieldName);
            sb.append("\tpublic ").append(javaType.getSimpleName()).append(" ").append(getFieldName).append("(){\n");
            sb.append("\t\treturn ").append(fieldName).append(";\n");
            sb.append("\t}\n\n");
            String setFieldName = "set" + StrUtils.toUpperCaseFirstOne(fieldName);
            if (linkStyle) {
                sb.append("\tpublic ").append(className).append(" ").append(setFieldName).append("(").append(javaType.getSimpleName()).append(" ").append(fieldName).append("){\n");
                sb.append("\t\tthis.").append(fieldName).append("=").append(fieldName).append(";\n");
                sb.append("\t\treturn this;\n");
            } else {
                sb.append("\tpublic ").append("void").append(" ").append(setFieldName).append("(").append(javaType.getSimpleName()).append(" ").append(fieldName).append("){\n");
                sb.append("\t\tthis.").append(fieldName).append("=").append(fieldName).append(";\n");
            }
            sb.append("\t}\n\n");
        }
        body.append(pkeySB.toString()).append(normalSB.toString());
    }
}

