/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdialects.ArrayUtils;
import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.DbContext;
import com.github.drinkjava2.jsqlbox.DbContextUtils;
import com.github.drinkjava2.jsqlbox.DbException;
import com.github.drinkjava2.jsqlbox.EntityType;
import com.github.drinkjava2.jsqlbox.TailType;
import com.github.drinkjava2.jsqlbox.entitynet.EntityNet;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.dbutils.ResultSetHandler;

public class ActiveRecord<T>
implements TailType,
EntityType {
    static final ThreadLocal<String[]> forFieldsOrTails = new ThreadLocal();
    static final ThreadLocal<Boolean> isForfield = new ThreadLocal();
    private DbContext ctx;
    private Map<String, Object> tailsMap;

    protected void miscMethods__________________() {
    }

    public DbContext ctx() {
        if (this.ctx != null) {
            return this.ctx;
        }
        DbException.assureNotNull(DbContext.globalDbContext, "No default global DbContext found, need use method DbContext.setGlobalDbContext() to set a global default DbContext instance at the beginning of appication.");
        return DbContext.globalDbContext;
    }

    public TableModel model() {
        return DbContextUtils.findEntityOrClassTableModel(this).newCopy();
    }

    public T useContext(DbContext ctx) {
        this.ctx = ctx;
        return (T)this;
    }

    @Override
    public Map<String, Object> tails() {
        if (this.tailsMap == null) {
            this.tailsMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        }
        return this.tailsMap;
    }

    public <V> V getField(String fieldName) {
        return (V)ClassCacheUtils.readValueFromBeanField(this, fieldName);
    }

    public <V> V getTail(String columnName) {
        if (this.tailsMap == null) {
            return null;
        }
        return (V)this.tailsMap.get(columnName);
    }

    public T putTail(Object ... columAndValues) {
        DbException.assureTrue(columAndValues.length % 2 == 0, "Column and values should be paired");
        for (int i = 0; i < columAndValues.length / 2; ++i) {
            this.tails().put((String)columAndValues[i * 2], columAndValues[i * 2 + 1]);
        }
        return (T)this;
    }

    public T putField(Object ... fieldAndValues) {
        DbException.assureTrue(fieldAndValues.length % 2 == 0, "Field and values should be paired");
        for (int i = 0; i < fieldAndValues.length / 2; ++i) {
            ClassCacheUtils.writeValueToBeanField(this, (String)fieldAndValues[i * 2], fieldAndValues[i * 2 + 1]);
        }
        return (T)this;
    }

    public T forFields(String ... fieldNames) {
        forFieldsOrTails.set(fieldNames);
        isForfield.set(true);
        return (T)this;
    }

    public T forTails(String ... columnNames) {
        forFieldsOrTails.set(columnNames);
        isForfield.set(false);
        return (T)this;
    }

    public T putValues(Object ... values) {
        String[] fields = forFieldsOrTails.get();
        if (values.length == 0 || fields == null || fields.length == 0) {
            throw new DbException("putValues fields or values can not be empty");
        }
        if (values.length != fields.length) {
            throw new DbException("putValues quantity does not match forFields or forColumns");
        }
        for (int i = 0; i < fields.length; ++i) {
            if (isForfield.get().booleanValue()) {
                ClassCacheUtils.writeValueToBeanField(this, fields[i], values[i]);
                continue;
            }
            this.tails().put(fields[i], values[i]);
        }
        return (T)this;
    }

    public String shardTB(Object ... items) {
        TableModel model = DbContextUtils.findTableModel(this.getClass(), items);
        ColumnModel col = model.getShardTableColumn();
        if (col == null || col.getShardTable() == null || col.getShardTable().length == 0) {
            throw new DbException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = DbContextUtils.readValueFromBeanFieldOrTail(col, this, false, false);
        return DbContextUtils.getShardedTB(this.ctx(), model.getEntityClass(), shardKey1);
    }

    public DbContext shardDB(Object ... items) {
        TableModel model = DbContextUtils.findTableModel(this.getClass(), items);
        ColumnModel col = model.getShardDatabaseColumn();
        if (col == null || col.getShardDatabase() == null || col.getShardDatabase().length == 0) {
            throw new DbException("Not found ShardTable setting for '" + model.getEntityClass() + "'");
        }
        Object shardKey1 = DbContextUtils.readValueFromBeanFieldOrTail(col, this, false, false);
        return DbContextUtils.getShardedDB(this.ctx(), model.getEntityClass(), shardKey1);
    }

    public Object[] shard(Object ... items) {
        return new Object[]{this.shardTB(items), this.shardDB(items)};
    }

    protected static Object[] insertThisClassIfNotHave(Object entity, Object ... items) {
        Object[] newItems = items;
        TableModel[] models = DbContextUtils.findAllModels(items);
        if (models.length == 0) {
            throw new DbException("No TableMode found for entity.");
        }
        TableModel model = models[0];
        if (!entity.getClass().equals(model.getEntityClass())) {
            model = TableModelUtils.entity2ReadOnlyModel(entity.getClass());
            newItems = ArrayUtils.insertArray(model, items);
        }
        return newItems;
    }

    protected void crudMethods__________________() {
    }

    public T insert(Object ... items) {
        return (T)this.ctx().eInsert(this, items);
    }

    public T update(Object ... items) {
        return this.ctx().eUpdate(this, items);
    }

    public int updateTry(Object ... items) {
        return this.ctx().eUpdateTry(this, items);
    }

    public void delete(Object ... items) {
        this.ctx().eDelete(this, items);
    }

    public int deleteTry(Object ... items) {
        return this.ctx().eDeleteTry(this, items);
    }

    public void deleteById(Object id, Object ... items) {
        this.ctx().eDeleteById(this.getClass(), id, items);
    }

    public int deleteByIdTry(Object id, Object ... items) {
        return this.ctx().eDeleteByIdTry(this.getClass(), id, items);
    }

    public boolean existStrict(Object ... items) {
        return this.ctx().eExistStrict(this, items);
    }

    public boolean existId(Object ... items) {
        return this.ctx().eExist(this, items);
    }

    public boolean existById(Object id, Object ... items) {
        return this.ctx().eExistById(this.getClass(), id, items);
    }

    public int countAll(Object ... items) {
        return this.ctx().eCountAll(this.getClass(), items);
    }

    public T load(Object ... items) {
        return (T)this.ctx().eLoad(this, items);
    }

    public int loadTry(Object ... items) {
        return this.ctx().eLoadTry(this, items);
    }

    public T loadById(Object id, Object ... items) {
        return (T)this.ctx().eLoadById(this.getClass(), id, items);
    }

    public T loadByIdTry(Object id, Object ... items) {
        return (T)this.ctx().eLoadByIdTry(this.getClass(), id, items);
    }

    public T loadBySQL(Object ... items) {
        return this.ctx().eLoadBySQL(items);
    }

    public List<T> findAll(Object ... items) {
        return this.ctx().eFindAll(this.getClass(), items);
    }

    public List<T> findBySQL(Object ... items) {
        return this.ctx().eFindBySQL(this.getClass(), items);
    }

    public List<T> findBySample(Object ... items) {
        return this.ctx().eFindBySample(this, items);
    }

    public EntityNet autoNet(Class<?> ... entityClass) {
        return this.ctx().autoNet(entityClass);
    }

    public <E> E findRelatedOne(Object ... items) {
        Object[] newItems = ActiveRecord.insertThisClassIfNotHave(this, items);
        return this.ctx().eFindRelatedOne(this, newItems);
    }

    public <E> List<E> findRelatedList(Object ... items) {
        Object[] newItems = ActiveRecord.insertThisClassIfNotHave(this, items);
        return this.ctx().eFindRelatedList(this, newItems);
    }

    public <E> Set<E> findRelatedSet(Object ... items) {
        Object[] newItems = ActiveRecord.insertThisClassIfNotHave(this, items);
        return this.ctx().eFindRelatedSet(this, newItems);
    }

    public <E> Map<Object, E> findRelatedMap(Object ... items) {
        Object[] newItems = ActiveRecord.insertThisClassIfNotHave(this, items);
        return this.ctx().eFindRelatedMap(this, newItems);
    }

    public <E> List<E> eFindAll(Class<E> entityClass, Object ... items) {
        return this.ctx().eFindAll(entityClass, items);
    }

    public <E> List<E> eFindBySample(Object sampleBean, Object ... items) {
        return this.ctx().eFindBySample(sampleBean, items);
    }

    public <E> List<E> eFindBySQL(Object ... items) {
        return this.ctx().eFindBySQL(items);
    }

    public <E> E eInsert(E entity, Object ... items) {
        return this.ctx().eInsert(entity, items);
    }

    public <E> E eLoad(E entity, Object ... items) {
        return this.ctx().eLoad(entity, items);
    }

    public <E> E eLoadById(Class<E> entityClass, Object entityId, Object ... items) {
        return this.ctx().eLoadById(entityClass, entityId, items);
    }

    public <E> E eLoadByIdTry(Class<E> entityClass, Object entityId, Object ... items) {
        return this.ctx().eLoadByIdTry(entityClass, entityId, items);
    }

    public <E> E eUpdate(Object entity, Object ... items) {
        return (E)this.ctx().eUpdate(entity, items);
    }

    public boolean eExist(Object entity, Object ... items) {
        return this.ctx().eExist(entity, items);
    }

    public boolean eExistById(Class<?> entityClass, Object id, Object ... items) {
        return this.ctx().eExistById(entityClass, id, items);
    }

    public int eCountAll(Class<?> entityClass, Object ... items) {
        return this.ctx().eCountAll(entityClass, items);
    }

    public int eDeleteByIdTry(Class<?> entityClass, Object id, Object ... items) {
        return this.ctx().eDeleteByIdTry(entityClass, id, items);
    }

    public int eDeleteTry(Object entity, Object ... items) {
        return this.ctx().eDeleteTry(entity, items);
    }

    public int eLoadTry(Object entity, Object ... items) {
        return this.ctx().eLoadTry(entity, items);
    }

    public int eUpdateTry(Object entity, Object ... items) {
        return this.ctx().eUpdateTry(entity, items);
    }

    public void eDelete(Object entity, Object ... items) {
        this.ctx().eDelete(entity, items);
    }

    public void eDeleteById(Class<?> entityClass, Object id, Object ... items) {
        this.ctx().eDeleteById(entityClass, id, items);
    }

    public <E> E eFindRelatedOne(Object entity, Object ... items) {
        return this.ctx().eFindRelatedOne(entity, items);
    }

    public <E> List<E> eFindRelatedList(Object entityOrIterable, Object ... items) {
        return this.ctx().eFindRelatedList(entityOrIterable, items);
    }

    public <E> Set<E> eFindRelatedSet(Object entity, Object ... items) {
        return this.ctx().eFindRelatedSet(entity, items);
    }

    public <E> Map<Object, E> eFindRelatedMap(Object entity, Object ... items) {
        return this.ctx().eFindRelatedMap(entity, items);
    }

    public <E> E pQuery(Object ... items) {
        return (E)this.ctx().pQuery(items);
    }

    public <E> E pQueryForObject(Object ... items) {
        return (E)this.ctx().pQueryForObject(items);
    }

    public long pQueryForLongValue(Object ... items) {
        return this.ctx().pQueryForLongValue(items);
    }

    public int pQueryForIntValue(Object ... items) {
        return this.ctx().pQueryForIntValue(items);
    }

    public String pQueryForString(Object ... items) {
        return this.ctx().pQueryForString(items);
    }

    public List<Map<String, Object>> pQueryForMapList(Object ... items) {
        return this.ctx().pQueryForMapList(items);
    }

    public int pUpdate(Object ... items) {
        return this.ctx().pUpdate(items);
    }

    public <E> E pInsert(Object ... items) {
        return (E)this.ctx().pInsert(items);
    }

    public <E> E pExecute(Object ... items) {
        return (E)this.ctx().pExecute(items);
    }

    public <E> List<E> pQueryForEntityList(Object ... items) {
        return this.ctx().pQueryForEntityList(items);
    }

    public <E> E iQuery(Object ... items) {
        return (E)this.ctx().iQuery(items);
    }

    public <E> E iQueryForObject(Object ... items) {
        return (E)this.ctx().iQueryForObject(items);
    }

    public long iQueryForLongValue(Object ... items) {
        return this.ctx().iQueryForLongValue(items);
    }

    public int iQueryForIntgValue(Object ... items) {
        return this.ctx().iQueryForIntValue(items);
    }

    public String iQueryForString(Object ... items) {
        return this.ctx().iQueryForString(items);
    }

    public List<Map<String, Object>> iQueryForMapList(Object ... items) {
        return this.ctx().iQueryForMapList(items);
    }

    public int iUpdate(Object ... items) {
        return this.ctx().iUpdate(items);
    }

    public <E> E iInsert(Object ... items) {
        return (E)this.ctx().iInsert(items);
    }

    public <E> E iExecute(Object ... items) {
        return (E)this.ctx().iExecute(items);
    }

    public <E> List<E> iQueryForEntityList(Object ... items) {
        return this.ctx().iQueryForEntityList(items);
    }

    public <E> E nQuery(Connection conn, ResultSetHandler<E> rsh, String sql, Object ... items) {
        return this.ctx().nQuery(conn, rsh, sql, items);
    }

    public <E> E nQueryForObject(Connection conn, String sql, Object ... items) {
        return (E)this.ctx().nQueryForObject(conn, sql, items);
    }

    public String nQueryForString(Connection conn, String sql, Object ... items) {
        return this.ctx().nQueryForString(conn, sql, items);
    }

    public long nQueryForLongValue(Connection conn, String sql, Object ... items) {
        return this.ctx().nQueryForLongValue(conn, sql, items);
    }

    public int nQueryForIntValue(Connection conn, String sql, Object ... items) {
        return this.ctx().nQueryForIntValue(conn, sql, items);
    }

    public List<Map<String, Object>> nQueryForMapList(Connection conn, String sql, Object ... items) {
        return this.ctx().nQueryForMapList(conn, sql, items);
    }

    public int nUpdate(Connection conn, String sql, Object ... items) {
        return this.ctx().nUpdate(conn, sql, items);
    }

    public <E> E nInsert(Connection conn, ResultSetHandler<E> rsh, String sql, Object ... items) {
        return this.ctx().nInsert(conn, rsh, sql, items);
    }

    public int nExecute(Connection conn, String sql, Object ... items) {
        return this.ctx().nExecute(conn, sql, items);
    }

    public <E> List<E> nExecute(Connection conn, ResultSetHandler<E> rsh, String sql, Object ... items) {
        return this.ctx().nExecute(conn, rsh, sql, items);
    }

    public <E> E nQuery(ResultSetHandler<E> rsh, String sql, Object ... items) {
        return this.ctx().nQuery(rsh, sql, items);
    }

    public <E> E nQueryForObject(String sql, Object ... items) {
        return (E)this.ctx().nQueryForObject(sql, items);
    }

    public String nQueryForString(String sql, Object ... items) {
        return this.ctx().nQueryForString(sql, items);
    }

    public long nQueryForLongValue(String sql, Object ... items) {
        return this.ctx().nQueryForLongValue(sql, items);
    }

    public int nQueryForIntValue(String sql, Object ... items) {
        return this.ctx().nQueryForIntValue(sql, items);
    }

    public List<Map<String, Object>> nQueryForMapList(String sql, Object ... items) {
        return this.ctx().nQueryForMapList(sql, items);
    }

    public int nUpdate(String sql, Object ... items) {
        return this.ctx().nUpdate(sql, items);
    }

    public <E> E nInsert(ResultSetHandler rsh, String sql, Object ... items) {
        return (E)this.ctx().nInsert(rsh, sql, items);
    }

    public int nExecute(String sql, Object ... items) {
        return this.ctx().nExecute(sql, items);
    }

    public <E> List<E> nExecute(ResultSetHandler rsh, String sql, Object ... items) {
        return this.ctx().nExecute(rsh, sql, items);
    }

    public <E> E tQuery(Object ... items) {
        return (E)this.ctx().tQuery(items);
    }

    public <E> E tQueryForObject(Object ... items) {
        return (E)this.ctx().tQueryForObject(items);
    }

    public long tQueryForLongValue(Object ... items) {
        return this.ctx().tQueryForLongValue(items);
    }

    public int tQueryForIntValue(Object ... items) {
        return this.ctx().tQueryForIntValue(items);
    }

    public String tQueryForString(Object ... items) {
        return this.ctx().tQueryForString(items);
    }

    public List<Map<String, Object>> tQueryForMapList(Object ... items) {
        return this.ctx().tQueryForMapList(items);
    }

    public int tUpdate(Object ... items) {
        return this.ctx().tUpdate(items);
    }

    public <E> E tInsert(Object ... items) {
        return (E)this.ctx().tInsert(items);
    }

    public <E> E tExecute(Object ... items) {
        return (E)this.ctx().tExecute(items);
    }

    public <E> List<E> tQueryForEntityList(Class<E> entityClass, Object ... items) {
        return this.ctx().tQueryForEntityList(entityClass, items);
    }
}

