/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox;

import com.github.drinkjava2.jdbpro.DbPro;
import com.github.drinkjava2.jdbpro.DbProException;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SqlItem;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdbpro.template.BasicSqlTemplate;
import com.github.drinkjava2.jdialects.Dialect;
import com.github.drinkjava2.jdialects.DialectException;
import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.TableModelUtilsOfDb;
import com.github.drinkjava2.jdialects.id.SnowflakeCreator;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jdialects.springsrc.utils.ClassUtils;
import com.github.drinkjava2.jdialects.springsrc.utils.CollectionUtils;
import com.github.drinkjava2.jsqlbox.DbContextUtils;
import com.github.drinkjava2.jsqlbox.DbException;
import com.github.drinkjava2.jsqlbox.entitynet.EntityNet;
import com.github.drinkjava2.jsqlbox.gtx.GtxConnectionManager;
import com.github.drinkjava2.jsqlbox.gtx.GtxInfo;
import com.github.drinkjava2.jsqlbox.gtx.GtxUtils;
import com.github.drinkjava2.jsqlbox.handler.EntityListHandler;
import com.github.drinkjava2.jsqlbox.handler.EntityNetHandler;
import com.github.drinkjava2.jsqlbox.sharding.ShardingModTool;
import com.github.drinkjava2.jsqlbox.sharding.ShardingRangeTool;
import com.github.drinkjava2.jsqlbox.sharding.ShardingTool;
import com.github.drinkjava2.jtransactions.tinytx.TinyTxConnectionManager;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class DbContext
extends DbPro {
    protected static ShardingTool[] globalNextShardingTools = new ShardingTool[]{new ShardingModTool(), new ShardingRangeTool()};
    protected static SnowflakeCreator globalNextSnowflakeCreator = null;
    protected static Object[] globalNextSsModels = null;
    protected static boolean globalNextIgnoreNull = false;
    protected static boolean globalNextIgnoreEmpty = false;
    protected static Object globalNextAuditorGetter = null;
    public static final String NO_GLOBAL_SQLBOXCONTEXT_FOUND = "No default global DbContext found, need use method DbContext.setGlobalDbContext() to set a global default DbContext instance at the beginning of appication.";
    protected static DbContext globalDbContext = new DbContext();
    protected ShardingTool[] shardingTools = globalNextShardingTools;
    protected SnowflakeCreator snowflakeCreator = globalNextSnowflakeCreator;
    protected TableModel[] tailModels;
    protected boolean ignoreNull = globalNextIgnoreNull;
    protected boolean ignoreEmpty = globalNextIgnoreEmpty;
    protected Object auditorGetter = globalNextAuditorGetter;
    private Method methodOfGetCurrentAuditor = null;

    public DbContext() {
    }

    public DbContext(DataSource ds) {
        super(ds);
    }

    public DbContext(DataSource ds, Dialect dialect) {
        super(ds, dialect);
    }

    public boolean isGtxOpen() {
        return this.connectionManager instanceof GtxConnectionManager && this.getGtxManager().isInTransaction();
    }

    public GtxInfo getGtxInfo() {
        return (GtxInfo)this.getGtxManager().getThreadTxInfo();
    }

    public GtxConnectionManager getGtxManager() {
        return (GtxConnectionManager)this.connectionManager;
    }

    protected void miscMethods______________________________() {
    }

    public static void resetGlobalVariants() {
        DbContext.setGlobalNextAllowShowSql(false);
        DbContext.setGlobalNextMasterSlaveOption(SqlOption.USE_AUTO);
        DbContext.setGlobalNextConnectionManager(TinyTxConnectionManager.instance());
        DbContext.setGlobalNextSqlHandlers(null);
        DbContext.setGlobalNextBatchSize(300);
        DbContext.setGlobalNextTemplateEngine(BasicSqlTemplate.instance());
        DbContext.setGlobalNextDialect(null);
        DbContext.setGlobalNextShardingTools(new ShardingTool[]{new ShardingModTool(), new ShardingRangeTool()});
        DbContext.setGlobalNextIgnoreNull(false);
        DbContext.setGlobalNextIgnoreEmpty(false);
        DbContext.setGlobalNextAuditorGetter(null);
        globalDbContext = new DbContext();
    }

    public static DbContext gctx() {
        return globalDbContext;
    }

    public static DbContext getGlobalDbContext() {
        return globalDbContext;
    }

    public Object getCurrentAuditor() {
        DbException.assureNotNull(this.auditorGetter, "Can not call getCurrentAuditor() when auditorGetter is null.");
        Object result = null;
        if (this.methodOfGetCurrentAuditor == null) {
            this.methodOfGetCurrentAuditor = ClassUtils.getMethod(this.auditorGetter.getClass(), "getCurrentAuditor", new Class[0]);
        }
        try {
            result = this.methodOfGetCurrentAuditor.invoke(this.auditorGetter, new Object[0]);
        }
        catch (Exception e) {
            throw new DialectException("Fail to call auditorGetter's getCurrentAuditor method. ", e);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean dealOneSqlItem(boolean iXxxStyle, PreparedSQL ps, Object item) {
        if (super.dealOneSqlItem(iXxxStyle, ps, item)) {
            return true;
        }
        if (item instanceof SqlOption) {
            if (SqlOption.IGNORE_EMPTY.equals(item)) {
                ps.setIgnoreEmpty(true);
                return true;
            } else if (SqlOption.IGNORE_NULL.equals(item)) {
                ps.setIgnoreNull(true);
                return true;
            } else {
                if (!SqlOption.AUTO_SQL.equals(item)) return false;
                DbContextUtils.appendLeftJoinSQL(ps);
            }
            return true;
        } else if (item instanceof TableModel) {
            ps.addModel(item);
            DbContextUtils.createLastAutoAliasName(ps);
            return true;
        } else {
            if (item instanceof Class) {
                ps.addModel(TableModelUtils.entity2ReadOnlyModel((Class)item));
                DbContextUtils.createLastAutoAliasName(ps);
                return true;
            }
            if (item instanceof SqlItem) {
                SqlItem sqItem = (SqlItem)item;
                SqlOption sqlItemType = sqItem.getType();
                if (SqlOption.SHARD_TABLE.equals((Object)sqlItemType)) {
                    this.handleShardTable(ps, sqItem);
                    return true;
                } else if (SqlOption.SHARD_DATABASE.equals((Object)sqlItemType)) {
                    this.handleShardDatabase(ps, sqItem);
                    return true;
                } else if (SqlOption.GIVE.equals((Object)sqlItemType)) {
                    Object[] o = ((SqlItem)item).getParameters();
                    String[] s = new String[o.length];
                    for (int i = 0; i < o.length; ++i) {
                        s[i] = (String)o[i];
                    }
                    ps.addGives(s);
                    return true;
                } else if (SqlOption.GIVE_BOTH.equals((Object)sqlItemType)) {
                    Object[] a = ((SqlItem)item).getParameters();
                    ps.addGives(new String[]{(String)a[0], (String)a[1]});
                    ps.addGives(new String[]{(String)a[1], (String)a[0]});
                    return true;
                } else {
                    if (!SqlOption.ALIAS.equals((Object)sqlItemType)) return SqlOption.TAIL.equals((Object)sqlItemType);
                    if (sqItem.getParameters().length == 0) {
                        throw new DbException("alias method need parameter");
                    }
                    ps.setLastAliases((String[])sqItem.getParameters());
                }
                return true;
            } else {
                if (!(item instanceof EntityNet)) return false;
                ps.setEntityNet((EntityNet)item);
                ps.addHandler(new EntityNetHandler());
            }
        }
        return true;
    }

    public String getShardedTB(Object entityOrClass, Object ... shardvalues) {
        String table = DbContextUtils.getShardedTB(this, entityOrClass, shardvalues);
        if (table == null) {
            throw new DbException("No found ShardingTool can handle target '" + entityOrClass + "' ");
        }
        return table;
    }

    public DbContext getShardedDB(Object entityOrClass, Object ... shardvalues) {
        DbContext ctx = DbContextUtils.getShardedDB(this, entityOrClass, shardvalues);
        if (ctx == null) {
            throw new DbException("Not found ShardingTool can handle entity '" + entityOrClass + "' ");
        }
        return ctx;
    }

    protected String handleShardTable(PreparedSQL predSQL, SqlItem item) {
        Object[] params = item.getParameters();
        String table = null;
        if (predSQL.getModels() == null || predSQL.getModels().length == 0) {
            throw new DbException("ShardTable not found model setting");
        }
        TableModel model = (TableModel)predSQL.getModels()[0];
        if (params.length == 1) {
            table = DbContextUtils.getShardedTB(this, model, params[0]);
        } else if (params.length == 2) {
            table = DbContextUtils.getShardedTB(this, model, params[0], params[1]);
        } else {
            throw new DbException("ShardTable need 1 or 2 parameters");
        }
        if (table == null) {
            throw new DbException("No ShardTable Tool found.");
        }
        predSQL.addSql(table);
        return table;
    }

    protected DbPro handleShardDatabase(PreparedSQL predSQL, SqlItem item) {
        Object[] params = item.getParameters();
        DbContext ctx = null;
        if (predSQL.getModels() == null || predSQL.getModels().length == 0) {
            return this;
        }
        TableModel model = (TableModel)predSQL.getModels()[0];
        if (params.length == 1) {
            ctx = DbContextUtils.getShardedDB(this, model, params[0]);
        } else if (params.length == 2) {
            ctx = DbContextUtils.getShardedDB(this, model, params[0], params[1]);
        } else {
            throw new DbException("ShardDatabase need 1 or 2 parameters");
        }
        if (ctx == null) {
            throw new DbException("No ShardDatabase Tool found.");
        }
        predSQL.setSwitchTo(ctx);
        return ctx;
    }

    private static void checkOnlyOneRowAffected(int result, String curdType) {
        if (result <= 0) {
            throw new DbException("No record found in database when do '" + curdType + "' operation.");
        }
        if (result > 1) {
            throw new DbException("Affect more than 1 row record in database when do '" + curdType + "' operation.");
        }
    }

    public <T> List<T> iQueryForEntityList(Object ... optionItems) {
        return (List)this.iQuery(new EntityListHandler(), optionItems);
    }

    public <T> List<T> pQueryForEntityList(Object ... optionItems) {
        return (List)this.pQuery(new EntityListHandler(), optionItems);
    }

    public <T> List<T> tQueryForEntityList(Object ... optionItems) {
        return (List)this.tQuery(new EntityListHandler(), optionItems);
    }

    public EntityNet autoNet(Class<?> ... entityClass) {
        return DbContextUtils.entityAutoNet(this, entityClass);
    }

    public void ensureTailModelLoaded() {
        if (this.tailModels != null) {
            return;
        }
        this.reloadTailModels();
    }

    public void startTransOnLockDb(int lockDb) {
        this.getConnectionManager().startTransaction();
        GtxConnectionManager gcm = (GtxConnectionManager)this.getConnectionManager();
        GtxInfo gtxInfo = (GtxInfo)gcm.getThreadTxInfo();
        gtxInfo.setLockDb(lockDb);
    }

    public synchronized void reloadTailModels() {
        DataSource ds = this.getDataSource();
        DbException.assureNotNull(ds, "Can not load tail TableModels when datasource is null");
        Connection conn = null;
        try {
            conn = this.getDataSource().getConnection();
            this.tailModels = TableModelUtilsOfDb.db2Models(conn, this.dialect);
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    DbException.eatException(e);
                }
            }
        }
    }

    protected void entityCrudMethods______________________________() {
    }

    public <T> T eInsert(T entity, Object ... optionItems) {
        int result = DbContextUtils.entityInsertTry(this, entity, optionItems);
        DbContext.checkOnlyOneRowAffected(result, "insert");
        return entity;
    }

    public <T> T eUpdate(Object entity, Object ... optionItems) {
        int result = DbContextUtils.entityUpdateTry(this, entity, optionItems);
        DbContext.checkOnlyOneRowAffected(result, "update");
        return (T)entity;
    }

    public int eUpdateTry(Object entity, Object ... optionItems) {
        return DbContextUtils.entityUpdateTry(this, entity, optionItems);
    }

    public void eDelete(Object entity, Object ... optionItems) {
        int result = DbContextUtils.entityDeleteTry(this, entity, optionItems);
        DbContext.checkOnlyOneRowAffected(result, "delete");
    }

    public int eDeleteTry(Object entity, Object ... optionItems) {
        return DbContextUtils.entityDeleteTry(this, entity, optionItems);
    }

    public void eDeleteById(Class<?> entityClass, Object id, Object ... optionItems) {
        int result = DbContextUtils.entityDeleteByIdTry(this, entityClass, id, optionItems);
        DbContext.checkOnlyOneRowAffected(result, "deleteById");
    }

    public int eDeleteByIdTry(Class<?> entityClass, Object id, Object ... optionItems) {
        return DbContextUtils.entityDeleteByIdTry(this, entityClass, id, optionItems);
    }

    public boolean eExistStrict(Object entity, Object ... optionItems) {
        return DbContextUtils.entityExistStrict(this, entity, optionItems);
    }

    public boolean eExist(Object entity, Object ... optionItems) {
        return DbContextUtils.entityExist(this, entity, optionItems);
    }

    public boolean eExistById(Class<?> entityClass, Object id, Object ... optionItems) {
        return DbContextUtils.entityExistById(this, entityClass, id, optionItems);
    }

    public int eCountAll(Class<?> entityClass, Object ... optionItems) {
        return DbContextUtils.entityCountAll(this, entityClass, optionItems);
    }

    public <T> T eLoad(T entity, Object ... optionItems) {
        int result = DbContextUtils.entityLoadTry(this, entity, optionItems);
        DbContext.checkOnlyOneRowAffected(result, "load");
        return entity;
    }

    public int eLoadTry(Object entity, Object ... optionItems) {
        return DbContextUtils.entityLoadTry(this, entity, optionItems);
    }

    public <T> T eLoadById(Class<T> entityClass, Object entityId, Object ... optionItems) {
        T entity = DbContextUtils.entityLoadByIdTry(this, entityClass, entityId, optionItems);
        if (entity == null) {
            throw new DbException("No record found in database when do 'LoadById' operation.");
        }
        return entity;
    }

    public <T> T eLoadBySQL(Object ... optionItems) {
        List<T> entities = this.iQueryForEntityList(optionItems);
        if (entities == null || entities.isEmpty()) {
            throw new DbException("No record found in database when try to load entity.");
        }
        if (entities.size() > 1) {
            throw new DbException("More than 1 record found when try to load 1 entity.");
        }
        return entities.get(0);
    }

    public <T> T eLoadByIdTry(Class<T> entityClass, Object entityId, Object ... optionItems) {
        return DbContextUtils.entityLoadByIdTry(this, entityClass, entityId, optionItems);
    }

    public <T> List<T> eFindAll(Class<T> entityClass, Object ... optionItems) {
        return DbContextUtils.entityFindAll(this, entityClass, optionItems);
    }

    public <T> List<T> eFindBySQL(Object ... optionItems) {
        return this.iQueryForEntityList(optionItems);
    }

    public <T> T eFindOneBySQL(Object ... optionItems) {
        List<T> objects = this.iQueryForEntityList(optionItems);
        if (CollectionUtils.isEmpty(objects)) {
            return null;
        }
        return objects.get(0);
    }

    public <T> List<T> eFindBySample(Object sampleBean, Object ... optionItems) {
        return DbContextUtils.entityFindBySample(this, sampleBean, optionItems);
    }

    public <E> E eFindRelatedOne(Object entity, Object ... sqlItems) {
        return DbContextUtils.entityFindRelatedOne(this, entity, sqlItems);
    }

    public <E> List<E> eFindRelatedList(Object entityOrIterable, Object ... sqlItems) {
        return DbContextUtils.entityFindRelatedList(this, entityOrIterable, sqlItems);
    }

    public <E> Set<E> eFindRelatedSet(Object entity, Object ... sqlItems) {
        return DbContextUtils.entityFindRelatedSet(this, entity, sqlItems);
    }

    public <E> Map<Object, E> eFindRelatedMap(Object entity, Object ... sqlItems) {
        return DbContextUtils.entityFindRelatedMap(this, entity, sqlItems);
    }

    protected void dialectShortcutMethods__________________________() {
    }

    public String pagin(int pageNumber, int pageSize, String sql) {
        this.assertDialectNotNull();
        return this.dialect.pagin(pageNumber, pageSize, sql);
    }

    public String trans(String sql) {
        this.assertDialectNotNull();
        return this.dialect.trans(sql);
    }

    public String paginAndTrans(int pageNumber, int pageSize, String sql) {
        this.assertDialectNotNull();
        return this.dialect.paginAndTrans(pageNumber, pageSize, sql);
    }

    public String[] toCreateDDL(Class<?> ... entityClasses) {
        this.assertDialectNotNull();
        return this.dialect.toCreateDDL(entityClasses);
    }

    public String[] toDropDDL(Class<?> ... entityClasses) {
        this.assertDialectNotNull();
        return this.dialect.toDropDDL(entityClasses);
    }

    public String[] toDropAndCreateDDL(Class<?> ... entityClasses) {
        this.assertDialectNotNull();
        return this.dialect.toDropAndCreateDDL(entityClasses);
    }

    public String[] toCreateDDL(TableModel ... tables) {
        this.assertDialectNotNull();
        return this.dialect.toCreateDDL(tables);
    }

    public String[] toCreateGtxLogDDL(Class<?> ... entityClasses) {
        this.assertDialectNotNull();
        TableModel[] mds = new TableModel[entityClasses.length];
        for (int i = 0; i < entityClasses.length; ++i) {
            mds[i] = GtxUtils.entity2GtxLogModel(entityClasses[i]);
        }
        return this.dialect.toCreateDDL(mds);
    }

    public String[] toDropDDL(TableModel ... tables) {
        this.assertDialectNotNull();
        return this.dialect.toDropDDL(tables);
    }

    public String[] toDropAndCreateDDL(TableModel ... tables) {
        this.assertDialectNotNull();
        return this.dialect.toDropAndCreateDDL(tables);
    }

    public void executeDDL(String[] sqls) {
        for (String sql : sqls) {
            this.nExecute(sql, new Object[0]);
        }
    }

    private void assertDialectNotNull() {
        if (this.dialect == null) {
            throw new DbProException("Try use a dialect method but dialect is null");
        }
    }

    protected void getteSetters__________________________() {
    }

    protected void staticGlobalNextMethods______________________() {
    }

    public static void setGlobalNextAuditorGetter(Object globalNextAuditorGetter) {
        DbContext.globalNextAuditorGetter = globalNextAuditorGetter;
    }

    public static void setGlobalNextIgnoreNull(boolean globalNextIgnoreNull) {
        DbContext.globalNextIgnoreNull = globalNextIgnoreNull;
    }

    public static void setGlobalNextIgnoreEmpty(boolean globalNextIgnoreEmpty) {
        DbContext.globalNextIgnoreEmpty = globalNextIgnoreEmpty;
    }

    public static ShardingTool[] getGlobalNextShardingTools() {
        return globalNextShardingTools;
    }

    public static void setGlobalNextShardingTools(ShardingTool[] shardingTools) {
        globalNextShardingTools = shardingTools;
    }

    public static SnowflakeCreator getGlobalNextSnowflakeCreator() {
        return globalNextSnowflakeCreator;
    }

    public static void setGlobalNextSnowflakeCreator(SnowflakeCreator snowflakeCreator) {
        globalNextSnowflakeCreator = snowflakeCreator;
    }

    public ShardingTool[] getShardingTools() {
        return this.shardingTools;
    }

    public void setShardingTools(ShardingTool[] shardingTools) {
        this.shardingTools = shardingTools;
    }

    public SnowflakeCreator getSnowflakeCreator() {
        return this.snowflakeCreator;
    }

    public void setSnowflakeCreator(SnowflakeCreator snowflakeCreator) {
        this.snowflakeCreator = snowflakeCreator;
    }

    public static void setGlobalDbContext(DbContext globalDbContext) {
        DbContext.globalDbContext = globalDbContext;
    }

    public TableModel[] getTailModels() {
        return this.tailModels;
    }

    public void setTailModels(TableModel[] tailModels) {
        this.tailModels = tailModels;
    }

    public boolean isIgnoreNull() {
        return this.ignoreNull;
    }

    public void setIgnoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
    }

    public boolean isIgnoreEmpty() {
        return this.ignoreEmpty;
    }

    public void setIgnoreEmpty(boolean ignoreEmpty) {
        this.ignoreEmpty = ignoreEmpty;
    }

    public Object getAuditorGetter() {
        return this.auditorGetter;
    }

    public void setAuditorGetter(Object auditorGetter) {
        this.auditorGetter = auditorGetter;
    }
}

