/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.converter;

import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jsqlbox.DbContextUtils;
import com.github.drinkjava2.jsqlbox.DbException;
import com.github.drinkjava2.jsqlbox.converter.BaseFieldConverter;
import java.lang.reflect.Method;

public class EnumOrdinalFieldConverter
extends BaseFieldConverter {
    @Override
    public Object entityFieldToDbValue(ColumnModel col, Object entity) {
        Object value = DbContextUtils.doReadFromFieldOrTail(col, entity);
        return value == null ? null : Integer.valueOf(((Enum)value).ordinal());
    }

    @Override
    public void writeDbValueToEntityField(Object entityBean, ColumnModel col, Object value) {
        if (value == null) {
            return;
        }
        try {
            Method writeMethod = ClassCacheUtils.getClassFieldWriteMethod(entityBean.getClass(), col.getEntityField());
            Method method = writeMethod.getParameterTypes()[0].getMethod("values", new Class[0]);
            Object[] enu = (Object[])method.invoke(null, new Object[0]);
            writeMethod.invoke(entityBean, enu[Integer.parseInt(value.toString())]);
        }
        catch (Exception e) {
            throw new DbException("Field '" + col.getEntityField() + "' can not write with value '" + value + "'", e);
        }
    }
}

