/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.converter;

import com.github.drinkjava2.jdialects.ClassCacheUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jsqlbox.DbContextUtils;
import com.github.drinkjava2.jsqlbox.DbException;
import com.github.drinkjava2.jsqlbox.converter.BaseFieldConverter;
import java.lang.reflect.Method;

public class EnumStringFieldConverter
extends BaseFieldConverter {
    @Override
    public Object entityFieldToDbValue(ColumnModel col, Object entity) {
        Object value = DbContextUtils.doReadFromFieldOrTail(col, entity);
        return value == null ? null : value.toString();
    }

    @Override
    public void writeDbValueToEntityField(Object entityBean, ColumnModel col, Object value) {
        if (value == null) {
            return;
        }
        try {
            Method writeMethod = null;
            writeMethod = ClassCacheUtils.getClassFieldWriteMethod(entityBean.getClass(), col.getEntityField());
            Object enu = Enum.valueOf(writeMethod.getParameterTypes()[0], (String)value);
            writeMethod.invoke(entityBean, enu);
        }
        catch (Exception e) {
            throw new DbException("Field '" + col.getEntityField() + "' can not write with value '" + value + "'", e);
        }
    }
}

