/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.converter;

import com.github.drinkjava2.jdbpro.JDBPRO;
import com.github.drinkjava2.jdbpro.LinkArrayList;
import com.github.drinkjava2.jdbpro.SqlOption;
import com.github.drinkjava2.jdialects.Type;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jsqlbox.DbContext;
import com.github.drinkjava2.jsqlbox.DbContextUtils;
import com.github.drinkjava2.jsqlbox.DbException;
import com.github.drinkjava2.jsqlbox.converter.BaseFieldConverter;

public class VersionFieldConverter
extends BaseFieldConverter {
    private static Object getFirstVersion(ColumnModel col, Object version) {
        if (version != null) {
            return version;
        }
        if (Type.INTEGER.equals((Object)col.getColumnType())) {
            return 0;
        }
        if (Type.SMALLINT.equals((Object)col.getColumnType())) {
            return (short)0;
        }
        if (Type.BIGINT.equals((Object)col.getColumnType())) {
            return 0L;
        }
        throw new DbException("Can not use " + (Object)((Object)col.getColumnType()) + " as version field for '" + col.getEntityField() + "'");
    }

    private static Object getNextVersion(ColumnModel col, Object version) {
        Number nextVersion;
        if (Type.INTEGER.equals((Object)col.getColumnType())) {
            nextVersion = (Integer)version + 1;
        } else if (Type.SMALLINT.equals((Object)col.getColumnType())) {
            nextVersion = Integer.valueOf((Short)version + 1).shortValue();
        } else if (Type.BIGINT.equals((Object)col.getColumnType())) {
            nextVersion = (Long)version + 1L;
        } else {
            throw new DbException("Can not use " + (Object)((Object)col.getColumnType()) + " as version field for '" + col.getEntityField() + "'");
        }
        return nextVersion;
    }

    @Override
    public void handleSQL(SqlOption sqlOption, DbContext ctx, ColumnModel col, Object entity, LinkArrayList<Object> sqlBody, LinkArrayList<Object> sqlWhere) {
        Object oldVersion = DbContextUtils.readValueFromBeanFieldOrTail(col, entity, false, false);
        Object firstOrOldVersion = VersionFieldConverter.getFirstVersion(col, oldVersion);
        Object nextVersion = VersionFieldConverter.getNextVersion(col, firstOrOldVersion);
        if (SqlOption.UPDATE.equals((Object)sqlOption)) {
            DbContextUtils.writeValueToBeanFieldOrTail(col, entity, nextVersion);
            if (!sqlBody.isEmpty()) {
                sqlBody.append(", ");
            }
            sqlBody.append(col.getColumnName()).append("=?").append(JDBPRO.param(nextVersion));
            if (!sqlWhere.isEmpty()) {
                sqlWhere.append(" and ");
            }
            sqlWhere.append(col.getColumnName()).append("=?").append(JDBPRO.param(firstOrOldVersion));
        } else if (SqlOption.DELETE.equals((Object)sqlOption)) {
            if (!sqlWhere.isEmpty()) {
                sqlWhere.append(" and ");
            }
            sqlWhere.append(col.getColumnName()).append("=?");
            sqlWhere.append(JDBPRO.param(firstOrOldVersion));
        } else if (SqlOption.INSERT.equals((Object)sqlOption)) {
            if (oldVersion != firstOrOldVersion) {
                DbContextUtils.writeValueToBeanFieldOrTail(col, entity, firstOrOldVersion);
            }
            sqlBody.append(col.getColumnName());
            sqlBody.append(JDBPRO.param(firstOrOldVersion)).append(",");
        }
    }
}

