/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.gtx;

import com.github.drinkjava2.jdialects.TableModelUtils;
import com.github.drinkjava2.jdialects.model.ColumnModel;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.DB;
import com.github.drinkjava2.jsqlbox.DbContext;
import com.github.drinkjava2.jsqlbox.DbContextUtils;
import com.github.drinkjava2.jsqlbox.DbException;
import com.github.drinkjava2.jsqlbox.gtx.GtxId;
import com.github.drinkjava2.jsqlbox.gtx.GtxInfo;
import com.github.drinkjava2.jsqlbox.gtx.GtxLock;
import com.github.drinkjava2.jsqlbox.gtx.GtxLog;
import com.github.drinkjava2.jtransactions.TransactionsException;
import java.util.HashSet;
import java.util.List;

public abstract class GtxUtils {
    public static final String GTXID = "gtxid";
    public static final String GTXLOGNO = "gtxlogno";
    public static final String GTXTYPE = "gtxtype";
    public static final String GTXDB = "gtxdb";
    public static final String GTXTB = "gtxtb";
    public static final String GTXENTITY = "gtxentity";
    public static final String GTXTOPIC = "gtxtopic";
    public static final String INSERT = "INSERT";
    public static final String EXISTID = "EXISTID";
    public static final String EXISTSTRICT = "EXSTRICT";
    public static final String BEFORE = "BEFORE";
    public static final String DELETE = "DELETE";
    public static final String AFTER = "AFTER";
    private static String[] topicShardingParam = null;

    public static void reg(DbContext dbCtx, Object entity, String operType) {
        if (entity instanceof GtxId) {
            return;
        }
        GtxLog log = new GtxLog(operType, entity);
        dbCtx.getGtxInfo().getGtxLogList().add(log);
        GtxInfo gtxInfo = dbCtx.getGtxInfo();
        List<GtxLock> locks = gtxInfo.getGtxLockList();
        TableModel model = TableModelUtils.entity2ReadOnlyModel(entity.getClass());
        Integer dbCode = DbContextUtils.getShardedDbCodeByBean(dbCtx, entity);
        TransactionsException.assureNotNull(dbCode, "dbCode can not determine for entity: " + entity);
        log.setGtxDB(dbCode);
        String shardedTB = DbContextUtils.getShardedTbByBean(dbCtx, entity);
        log.setGtxTB(shardedTB);
        StringBuilder idSB = new StringBuilder();
        for (ColumnModel col : model.getPKeyColumns()) {
            if (idSB.length() > 0) {
                idSB.append("|");
            }
            idSB.append(DbContextUtils.readValueFromBeanFieldOrTail(col, entity, false, false));
        }
        String id = idSB.toString();
        boolean lockExisted = false;
        for (GtxLock lk : locks) {
            if (!lk.getDb().equals(dbCode) || !lk.getTb().equalsIgnoreCase(shardedTB) || !lk.getEntityId().equalsIgnoreCase(id)) continue;
            lockExisted = true;
            break;
        }
        if (!lockExisted) {
            GtxLock lock = new GtxLock();
            lock.setDb(dbCode);
            lock.setTb(shardedTB);
            lock.setEntityId(id);
            lock.setEntityTb(model.getTableName());
            lock.setGid(gtxInfo.getGtxId().getGid());
            locks.add(lock);
        }
    }

    public static void saveLockAndLog(DbContext lockCtx, GtxInfo gtxInfo) throws Exception {
        DbException.assureNotNull(gtxInfo.getGtxId(), "GtxId not set");
        DbContext locker = lockCtx;
        if (gtxInfo.getLockDb() != null) {
            locker = (DbContext)lockCtx.getMasters()[gtxInfo.getLockDb()];
        }
        locker.getConnectionManager().startTransaction(2);
        try {
            locker.eInsert(gtxInfo.getGtxId(), new Object[0]);
            Long logNo = 1L;
            for (GtxLog gtxLog : gtxInfo.getGtxLogList()) {
                Object entity = gtxLog.getEntity();
                TableModel md = GtxUtils.entity2GtxLogModel(entity.getClass());
                md.getColumnByColName(GTXID).setValue(gtxInfo.getGtxId().getGid());
                Long l = logNo;
                Long l2 = logNo = Long.valueOf(logNo + 1L);
                md.getColumnByColName(GTXLOGNO).setValue(l);
                md.getColumnByColName(GTXTYPE).setValue(gtxLog.getLogType());
                md.getColumnByColName(GTXDB).setValue(gtxLog.getGtxDB());
                md.getColumnByColName(GTXTB).setValue(gtxLog.getGtxTB());
                md.getColumnByColName(GTXENTITY).setValue(entity.getClass().getName());
                locker.eInsert(entity, md);
            }
            for (GtxLock lock : gtxInfo.getGtxLockList()) {
                locker.eInsert(lock, new Object[0]);
            }
            locker.getConnectionManager().commitTransaction();
        }
        catch (Exception e) {
            locker.getConnectionManager().rollbackTransaction();
            throw e;
        }
    }

    public static void deleteLockAndLog(DbContext lockCtx, GtxInfo gtxInfo) throws Exception {
        DbContext locker = lockCtx;
        if (gtxInfo.getLockDb() != null) {
            locker = (DbContext)lockCtx.getMasters()[gtxInfo.getLockDb()];
        }
        locker.getConnectionManager().startTransaction(2);
        try {
            String gid = gtxInfo.getGtxId().getGid();
            locker.eDelete(gtxInfo.getGtxId(), new Object[0]);
            locker.pExecute("delete from gtxlock where gid=?", gid, DB.shardDB(gid));
            HashSet<String> tableSet = new HashSet<String>();
            for (GtxLog gtxLog : gtxInfo.getGtxLogList()) {
                Object entity = gtxLog.getEntity();
                TableModel md = TableModelUtils.entity2ReadOnlyModel(entity.getClass());
                tableSet.add(md.getTableName().toLowerCase());
            }
            for (String table : tableSet) {
                locker.iExecute("delete from ", table, " where ", GTXID, "=?", DB.param(gid), DB.shardDB(gid));
            }
            locker.getConnectionManager().commitTransaction();
        }
        catch (Exception e) {
            locker.getConnectionManager().rollbackTransaction();
            throw e;
        }
    }

    public static TableModel entity2GtxLogModel(Class<?> entityClass) {
        TableModel t = TableModelUtils.entity2Model(entityClass);
        t.setIdGenerators(null);
        t.setIndexConsts(null);
        t.setUniqueConsts(null);
        for (ColumnModel col : t.getColumns()) {
            col.setPkey(false);
            col.setIdGenerationType(null);
            col.setIdGeneratorName(null);
            col.setShardTable(null);
            col.setShardDatabase(null);
            col.setShardDatabase(null);
            col.setShardTable(null);
        }
        t.column(GTXID).CHAR(32).id().setValueExist(true);
        t.column(GTXLOGNO).LONG().id().setValueExist(true);
        t.column(GTXTYPE).CHAR(8).setValueExist(true);
        t.column(GTXDB).INTEGER().setValueExist(true);
        t.column(GTXTB).VARCHAR(64).setValueExist(true);
        t.column(GTXENTITY).VARCHAR(255).setValueExist(true);
        ColumnModel topicCol = t.column(GTXTOPIC).VARCHAR(50).setValueExist(true);
        if (topicShardingParam != null) {
            topicCol.setShardDatabase(topicShardingParam);
        }
        TableModel.sortColumns(t.getColumns());
        return t;
    }
}

