/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jsqlbox.handler;

import com.github.drinkjava2.jdbpro.DefaultOrderSqlHandler;
import com.github.drinkjava2.jdbpro.ImprovedQueryRunner;
import com.github.drinkjava2.jdbpro.PreparedSQL;
import com.github.drinkjava2.jdbpro.SingleTonHandlers;
import com.github.drinkjava2.jdialects.model.TableModel;
import com.github.drinkjava2.jsqlbox.DbContextUtils;
import com.github.drinkjava2.jsqlbox.DbException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EntityListHandler
extends DefaultOrderSqlHandler {
    @Override
    public Object handle(ImprovedQueryRunner runner, PreparedSQL ps) {
        Object[] tableModels = ps.getModels();
        if (tableModels == null || tableModels.length == 0) {
            throw new DbException("TableModel setting needed for EntityListHandler");
        }
        if (tableModels.length > 1) {
            throw new DbException("TableModel setting should only have 1 for EntityListHandler");
        }
        TableModel model = (TableModel)tableModels[0];
        ps.setResultSetHandler(SingleTonHandlers.mapListHandler);
        List maps = (List)runner.runPreparedSQL(ps);
        ArrayList entityList = new ArrayList();
        for (Map row : maps) {
            Object entity = DbContextUtils.mapToEntityBean(model, row);
            entityList.add(entity);
        }
        return entityList;
    }
}

