/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.spring;

import com.github.drinkjava2.jtransactions.ConnectionManager;
import com.github.drinkjava2.jtransactions.DataSourceHolder;
import com.github.drinkjava2.jtransactions.TransactionsException;
import com.github.drinkjava2.jtransactions.TxResult;
import java.lang.reflect.Method;
import java.sql.Connection;
import javax.sql.DataSource;

public class SpringTxConnectionManager
implements ConnectionManager {
    protected final Method getConnectionMethod;
    protected final Method releaseConnectionMethod;
    protected final Method isActualTransactionActive;

    public SpringTxConnectionManager() {
        Class<?> transactionSynchronizationManagerClass;
        Class<?> dataSourceUtilClass;
        try {
            dataSourceUtilClass = Class.forName("org.springframework.jdbc.datasource.DataSourceUtils");
        }
        catch (ClassNotFoundException e) {
            throw new TransactionsException("Error:spring-jdbc jar missing, fail to build SpringTxConnectionManager.", e);
        }
        try {
            transactionSynchronizationManagerClass = Class.forName("org.springframework.transaction.support.TransactionSynchronizationManager");
        }
        catch (ClassNotFoundException e) {
            throw new TransactionsException("Error:spring-tx jar missing, fail to build SpringTxConnectionManager.", e);
        }
        try {
            this.getConnectionMethod = dataSourceUtilClass.getMethod("getConnection", DataSource.class);
            this.releaseConnectionMethod = dataSourceUtilClass.getMethod("releaseConnection", Connection.class, DataSource.class);
            this.isActualTransactionActive = transactionSynchronizationManagerClass.getMethod("isActualTransactionActive", new Class[0]);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: SpringTxConnectionManager initialize failed.", e);
        }
    }

    public static final SpringTxConnectionManager instance() {
        return SpringTxConnectionManagerSingleton.INSTANCE;
    }

    @Override
    public void startTransaction() {
        throw new TransactionsException("startTransaction method not implemented by current version, please use Spring's method directly or submit a pull request");
    }

    @Override
    public void startTransaction(int txIsolationLevel) {
        throw new TransactionsException("startTransaction method not implemented by current version, please use Spring's method directly or submit a pull request");
    }

    @Override
    public Connection getConnection(Object dsOrHolder) {
        DataSource ds = dsOrHolder instanceof DataSource ? (DataSource)dsOrHolder : ((DataSourceHolder)dsOrHolder).getDataSource();
        try {
            return (Connection)this.getConnectionMethod.invoke(null, ds);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: SpringTxConnectionManager fail to get connection from dataSource.", e);
        }
    }

    @Override
    public void releaseConnection(Connection conn, Object dsOrHolder) {
        DataSource ds = dsOrHolder instanceof DataSource ? (DataSource)dsOrHolder : ((DataSourceHolder)dsOrHolder).getDataSource();
        try {
            this.releaseConnectionMethod.invoke(null, conn, ds);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: SpringTxConnectionManager fail to release connection.", e);
        }
    }

    @Override
    public boolean isInTransaction() {
        try {
            return null != this.isActualTransactionActive.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new TransactionsException("Error: SpringTxConnectionManager fail to get transaction status.", e);
        }
    }

    @Override
    public TxResult commitTransaction() throws Exception {
        throw new TransactionsException("commit method not implemented by current version, please use Spring's method directly");
    }

    @Override
    public TxResult rollbackTransaction() {
        throw new TransactionsException("rollback method not implemented by current version, please use Spring's method directly");
    }

    private static class SpringTxConnectionManagerSingleton {
        private static final SpringTxConnectionManager INSTANCE = new SpringTxConnectionManager();

        private SpringTxConnectionManagerSingleton() {
        }
    }
}

