/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jtransactions.tinytx;

import com.github.drinkjava2.jtransactions.TransactionsException;
import com.github.drinkjava2.jtransactions.tinytx.TinyTxConnectionManager;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class TinyTxAOP
implements MethodInterceptor {
    private TinyTxConnectionManager cm = TinyTxConnectionManager.instance();
    private int transactionIsolation = 2;

    public TinyTxAOP() {
    }

    public TinyTxAOP(Integer transactionIsolation) {
        this.transactionIsolation = transactionIsolation;
    }

    public TinyTxAOP(TinyTxConnectionManager cm, Integer transactionIsolation) {
        this.cm = cm;
        this.transactionIsolation = transactionIsolation;
    }

    @Override
    public Object invoke(MethodInvocation caller) throws Throwable {
        if (this.cm.isInTransaction()) {
            return caller.proceed();
        }
        Object invokeResult = null;
        try {
            this.cm.startTransaction(this.transactionIsolation);
            invokeResult = caller.proceed();
            this.cm.commitTransaction();
        }
        catch (Throwable t) {
            this.cm.rollbackTransaction();
            throw new TransactionsException("TinyTx found a runtime Exception, transaction rollbacked.", t);
        }
        return invokeResult;
    }
}

