/*
 * Decompiled with CFR 0.152.
 */
package com.github.kfcfans.powerjob.worker.autoconfigure;

import com.github.kfcfans.powerjob.common.utils.CommonUtils;
import com.github.kfcfans.powerjob.worker.OhMyWorker;
import com.github.kfcfans.powerjob.worker.autoconfigure.PowerJobProperties;
import com.github.kfcfans.powerjob.worker.common.OhMyConfig;
import java.util.Arrays;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration
@EnableConfigurationProperties(value={PowerJobProperties.class})
@Conditional(value={PowerJobWorkerCondition.class})
public class PowerJobAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public OhMyWorker initPowerJob(PowerJobProperties properties) {
        PowerJobProperties.Worker worker = properties.getWorker();
        CommonUtils.requireNonNull((Object)worker.getServerAddress(), (String)"serverAddress can't be empty!");
        List<String> serverAddress = Arrays.asList(worker.getServerAddress().split(","));
        OhMyConfig config = new OhMyConfig();
        config.setPort(worker.getAkkaPort());
        config.setAppName(worker.getAppName());
        config.setServerAddress(serverAddress);
        config.setStoreStrategy(worker.getStoreStrategy());
        config.setEnableTestMode(worker.isEnableTestMode());
        OhMyWorker ohMyWorker = new OhMyWorker();
        ohMyWorker.setConfig(config);
        return ohMyWorker;
    }

    static class PowerJobWorkerCondition
    extends AnyNestedCondition {
        public PowerJobWorkerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="powerjob.worker", name={"server-address"})
        static class PowerJobWorkerProperty {
            PowerJobWorkerProperty() {
            }
        }

        @Deprecated
        @ConditionalOnProperty(prefix="powerjob", name={"server-address"})
        static class PowerJobProperty {
            PowerJobProperty() {
            }
        }
    }
}

