/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.handler;

import com.github.monkeywie.proxyee.exception.HttpProxyExceptionHandle;
import com.github.monkeywie.proxyee.handler.HttpProxyServerHandle;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptPipeline;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.util.ReferenceCountUtil;

public class HttpProxyClientHandle
extends ChannelInboundHandlerAdapter {
    private Channel clientChannel;

    public HttpProxyClientHandle(Channel clientChannel) {
        this.clientChannel = clientChannel;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!this.clientChannel.isOpen()) {
            ReferenceCountUtil.release((Object)msg);
            return;
        }
        HttpProxyInterceptPipeline interceptPipeline = ((HttpProxyServerHandle)this.clientChannel.pipeline().get("serverHandle")).getInterceptPipeline();
        if (msg instanceof HttpResponse) {
            interceptPipeline.afterResponse(this.clientChannel, ctx.channel(), (HttpResponse)msg);
        } else if (msg instanceof HttpContent) {
            interceptPipeline.afterResponse(this.clientChannel, ctx.channel(), (HttpContent)msg);
        } else {
            this.clientChannel.writeAndFlush(msg);
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().close();
        this.clientChannel.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.channel().close();
        this.clientChannel.close();
        HttpProxyExceptionHandle exceptionHandle = ((HttpProxyServerHandle)this.clientChannel.pipeline().get("serverHandle")).getExceptionHandle();
        exceptionHandle.afterCatch(this.clientChannel, ctx.channel(), cause);
    }
}

