/*
 * Decompiled with CFR 0.152.
 */
package com.github.monkeywie.proxyee.proxy;

import com.github.monkeywie.proxyee.proxy.ProxyConfig;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class ProxyHandleFactory {
    public static ProxyHandler build(ProxyConfig config) {
        Socks4ProxyHandler proxyHandler = null;
        if (config != null) {
            boolean isAuth = config.getUser() != null && config.getPwd() != null;
            InetSocketAddress inetSocketAddress = new InetSocketAddress(config.getHost(), config.getPort());
            switch (config.getProxyType()) {
                case HTTP: {
                    if (isAuth) {
                        proxyHandler = new HttpProxyHandler((SocketAddress)inetSocketAddress, config.getUser(), config.getPwd());
                        break;
                    }
                    proxyHandler = new HttpProxyHandler((SocketAddress)inetSocketAddress);
                    break;
                }
                case SOCKS4: {
                    proxyHandler = new Socks4ProxyHandler((SocketAddress)inetSocketAddress);
                    break;
                }
                case SOCKS5: {
                    proxyHandler = isAuth ? new Socks5ProxyHandler((SocketAddress)inetSocketAddress, config.getUser(), config.getPwd()) : new Socks5ProxyHandler((SocketAddress)inetSocketAddress);
                }
            }
        }
        return proxyHandler;
    }
}

