/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean;

import jetbrick.bean.Getter;
import jetbrick.bean.KlassInfo;
import jetbrick.bean.MethodInfo;
import jetbrick.bean.Setter;
import jetbrick.util.ArrayUtils;

public final class PropertyInfo
implements Getter,
Setter {
    private final KlassInfo declaringKlass;
    private final String name;
    private MethodInfo getter;
    private MethodInfo setter;

    protected PropertyInfo(KlassInfo declaringKlass, String name) {
        this.declaringKlass = declaringKlass;
        this.name = name;
    }

    public KlassInfo getDeclaringKlass() {
        return this.declaringKlass;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        if (this.getter != null) {
            return this.getter.getReturnType();
        }
        if (this.setter != null) {
            return this.setter.getParameterTypes()[0];
        }
        throw new IllegalStateException("Invalid PropertyInfo: " + this.toString());
    }

    public Class<?> getRawType(KlassInfo declaringKlass) {
        return this.getRawType(declaringKlass.getType());
    }

    public Class<?> getRawType(Class<?> declaringClass) {
        if (this.getter != null) {
            return this.getter.getRawReturnType(declaringClass);
        }
        if (this.setter != null) {
            return this.setter.getParameters().get(0).getRawType(declaringClass);
        }
        throw new IllegalStateException("Invalid PropertyInfo: " + this.toString());
    }

    public Class<?> getRawComponentType(Class<?> declaringClass, int componentIndex) {
        if (this.getter != null) {
            return this.getter.getRawReturnComponentType(declaringClass, componentIndex);
        }
        if (this.setter != null) {
            return this.setter.getParameters().get(0).getRawComponentType(declaringClass, componentIndex);
        }
        throw new IllegalStateException("Invalid PropertyInfo: " + this.toString());
    }

    public MethodInfo getGetter() {
        return this.getter;
    }

    public MethodInfo getSetter() {
        return this.setter;
    }

    protected void setGetter(MethodInfo getter) {
        this.getter = getter;
    }

    protected void setSetter(MethodInfo setter) {
        this.setter = setter;
    }

    public boolean readable() {
        return this.getter != null;
    }

    public boolean writable() {
        return this.setter != null;
    }

    @Override
    public Object get(Object object) {
        if (this.getter == null) {
            throw new IllegalStateException("Property is not readable: " + this.name);
        }
        return this.getter.invoke(object, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    @Override
    public void set(Object object, Object value) {
        if (this.setter == null) {
            throw new IllegalStateException("Property is not writable: " + this.name);
        }
        this.setter.invoke(object, value);
    }

    public String toString() {
        return this.declaringKlass.getName() + '#' + this.name;
    }
}

