/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.collection;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class CaseInsensitiveHashMap<V>
extends HashMap<String, V> {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> caseInsensitiveKeys;
    private final Locale locale;

    public CaseInsensitiveHashMap() {
        this(16, null, false);
    }

    public CaseInsensitiveHashMap(boolean useOriginalKey) {
        this(16, null, useOriginalKey);
    }

    public CaseInsensitiveHashMap(Locale locale) {
        this(16, locale, false);
    }

    public CaseInsensitiveHashMap(Locale locale, boolean useOriginalKey) {
        this(16, locale, useOriginalKey);
    }

    public CaseInsensitiveHashMap(int initialCapacity) {
        this(initialCapacity, null, false);
    }

    public CaseInsensitiveHashMap(int initialCapacity, boolean useOriginalKey) {
        this(initialCapacity, null, useOriginalKey);
    }

    public CaseInsensitiveHashMap(int initialCapacity, Locale locale) {
        this(initialCapacity, locale, false);
    }

    public CaseInsensitiveHashMap(int initialCapacity, Locale locale, boolean useOriginalKey) {
        super(initialCapacity);
        this.caseInsensitiveKeys = useOriginalKey ? new HashMap<String, String>(initialCapacity) : null;
        this.locale = locale != null ? locale : Locale.getDefault();
    }

    @Override
    public V put(String key, V value) {
        if (this.caseInsensitiveKeys == null) {
            return super.put(this.getCaseInsensitiveKey(key), value);
        }
        this.caseInsensitiveKeys.put(this.getCaseInsensitiveKey(key), key);
        return super.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof String) {
            key = this.getCaseInsensitiveKey((String)key);
            if (this.caseInsensitiveKeys == null) {
                return super.containsKey(key);
            }
            return this.caseInsensitiveKeys.containsKey(key);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            key = this.getCaseInsensitiveKey((String)key);
            if (this.caseInsensitiveKeys == null) {
                return super.get(key);
            }
            return super.get(this.caseInsensitiveKeys.get(key));
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        if (key instanceof String) {
            key = this.getCaseInsensitiveKey((String)key);
            if (this.caseInsensitiveKeys == null) {
                return super.remove(key);
            }
            return super.remove(this.caseInsensitiveKeys.remove(key));
        }
        return null;
    }

    @Override
    public void clear() {
        if (this.caseInsensitiveKeys != null) {
            this.caseInsensitiveKeys.clear();
        }
        super.clear();
    }

    protected String getCaseInsensitiveKey(String key) {
        return key.toLowerCase(this.locale);
    }
}

