/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.config;

import java.io.InputStream;
import java.util.Properties;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class XmlPropertiesLoader {
    XmlPropertiesLoader() {
    }

    public static Properties load(InputStream is, boolean withRootName) {
        Properties props = new Properties();
        if (is == null) {
            return props;
        }
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader reader = null;
        try {
            reader = factory.createXMLStreamReader(is);
            StringBuilder sb = new StringBuilder();
            int level = 0;
            while (reader.hasNext()) {
                switch (reader.next()) {
                    case 1: {
                        if (level > 0 || withRootName) {
                            String tag = reader.getLocalName();
                            String value = reader.getAttributeValue(null, "value");
                            if (sb.length() > 0) {
                                sb.append('.');
                            }
                            sb.append(tag);
                            if (value != null) {
                                props.put(sb.toString(), value);
                            }
                        }
                        ++level;
                        break;
                    }
                    case 2: {
                        if (--level <= 0 && !withRootName) break;
                        int pos = sb.lastIndexOf(".");
                        sb.setLength(Math.max(0, pos));
                        break;
                    }
                    case 4: 
                    case 12: {
                        if (level <= 0 && !withRootName) break;
                        String value = reader.getText();
                        if ((value = value.trim()).length() <= 0) break;
                        props.put(sb.toString(), value);
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return props;
    }
}

