/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.io.resource;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import jetbrick.io.IoUtils;
import jetbrick.io.resource.Resource;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.util.PathUtils;

public abstract class AbstractResource
implements Resource {
    protected String relativePathName;

    @Override
    public void setRelativePathName(String relativePathName) {
        this.relativePathName = relativePathName;
    }

    @Override
    public String getRelativePathName() {
        return this.relativePathName;
    }

    @Deprecated
    public void setPath(String path) {
        this.relativePathName = path;
    }

    @Override
    @Deprecated
    public String getPath() {
        return this.relativePathName;
    }

    @Override
    public byte[] toByteArray() throws ResourceNotFoundException {
        return IoUtils.toByteArray(this.openStream());
    }

    @Override
    public char[] toCharArray(Charset charset) throws ResourceNotFoundException {
        return IoUtils.toCharArray(this.openStream(), charset);
    }

    @Override
    public String toString(Charset charset) throws ResourceNotFoundException {
        return IoUtils.toString(this.openStream(), charset);
    }

    @Override
    public File getFile() throws UnsupportedOperationException {
        return PathUtils.urlAsFile(this.getURL());
    }

    @Override
    public URI getURI() throws UnsupportedOperationException {
        try {
            return this.getURL().toURI();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public URL getURL() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFileName() {
        int slash = this.relativePathName.lastIndexOf(47);
        if (slash >= 0) {
            return this.relativePathName.substring(slash + 1);
        }
        return this.relativePathName;
    }

    @Override
    public boolean exist() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFile() {
        return false;
    }

    @Override
    public long length() {
        return -1L;
    }

    @Override
    public long lastModified() {
        return 0L;
    }
}

