/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.io.resource;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.zip.ZipFile;
import jetbrick.io.resource.ClasspathResource;
import jetbrick.io.resource.FileSystemResource;
import jetbrick.io.resource.JbossVfsResource;
import jetbrick.io.resource.Resource;
import jetbrick.io.resource.UrlResource;
import jetbrick.io.resource.ZipEntryResource;
import jetbrick.util.Validate;

public final class ResourceUtils {
    public static Resource create(String location) {
        Validate.notNull(location);
        if (location.startsWith("classpath:")) {
            return new ClasspathResource(location.substring("classpath:".length()));
        }
        if (location.startsWith("file:")) {
            String file = location.substring("file:".length());
            return new FileSystemResource(new File(file));
        }
        if (location.startsWith("jar:") || location.startsWith("zip:")) {
            int pos = location.indexOf("!/");
            String file = location.substring(3, pos);
            String entry = location.substring(pos + 1);
            try {
                return new ZipEntryResource(new ZipFile(file), entry);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return new FileSystemResource(new File(location));
    }

    public static Resource create(URL url) {
        Validate.notNull(url);
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            return new FileSystemResource(url);
        }
        if ("jar".equals(protocol) || "zip".equals(protocol)) {
            return new ZipEntryResource(url);
        }
        if ("vfs".equals(protocol)) {
            return new JbossVfsResource(url);
        }
        return new UrlResource(url);
    }
}

