/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;

public final class BooleanConvertor
implements Convertor<Boolean> {
    public static final BooleanConvertor INSTANCE = new BooleanConvertor();

    @Override
    public Boolean convert(String value) {
        String s = value.toLowerCase();
        if (s.equals("true") || s.equals("1") || s.equals("yes") || s.equals("y") || s.equals("on")) {
            return Boolean.TRUE;
        }
        if (s.equals("false") || s.equals("0") || s.equals("no") || s.equals("n") || s.equals("off")) {
            return Boolean.FALSE;
        }
        throw TypeCastException.create(value, Boolean.class, null);
    }

    @Override
    public Boolean convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value.getClass() == Boolean.class) {
            return (Boolean)value;
        }
        return this.convert(value.toString());
    }
}

